/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.maven.api.mojo;

import com.mulesoft.connectivity.linkweave.api.loader.impl.SourceOnlyWeaveResourceResolver;
import com.mulesoft.connectivity.maven.api.model.Level;
import com.mulesoft.connectivity.maven.api.model.Phase;
import com.mulesoft.connectivity.maven.api.model.PhaseSummary;
import com.mulesoft.connectivity.maven.api.model.Status;
import com.mulesoft.connectivity.maven.util.ExecutionReport;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ParserConfiguration;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolver;

public abstract class AbstractConnectivityMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    protected ClassLoader getCustomClassLoader() throws MojoExecutionException {
        try {
            URL[] urls = (URL[])this.project.getCompileClasspathElements().stream().distinct().map(e -> {
                try {
                    return new File((String)e).toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }).toArray(URL[]::new);
            return URLClassLoader.newInstance(urls, Thread.currentThread().getContextClassLoader());
        }
        catch (RuntimeException | DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    protected DataWeaveScriptingEngine getDwEngine(ParserConfiguration parserConfiguration) {
        SourceOnlyWeaveResourceResolver resourceResolver = new SourceOnlyWeaveResourceResolver((WeaveResourceResolver)ClassLoaderWeaveResourceResolver.apply());
        ModuleComponentsFactory moduleComponent = ModuleComponentsFactory.apply((WeaveResourceResolver)resourceResolver);
        return new DataWeaveScriptingEngine(moduleComponent, parserConfiguration);
    }

    protected static <T> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable) throws MojoExecutionException {
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        if (currentClassLoader != classLoader) {
            currentThread.setContextClassLoader(classLoader);
        }
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to execute withContextClassLoader", ex);
        }
        finally {
            if (currentClassLoader != classLoader) {
                currentThread.setContextClassLoader(currentClassLoader);
            }
        }
    }

    protected String throwableToString(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    protected void writeMojoResult(Phase phase, Status status) throws MojoExecutionException {
        this.writeMojoResult(phase, status, null, Collections.emptyMap());
    }

    protected void writeMojoResult(Phase phase, Status status, Throwable ex, Map<Level, List<String>> messages) throws MojoExecutionException {
        PhaseSummary phaseSummary = new PhaseSummary(phase, status, this.throwableToString(ex), messages);
        try (ExecutionReport executionReport = new ExecutionReport(this.project);){
            executionReport.update(phaseSummary);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    @Generated
    public void setProject(MavenProject project) {
        this.project = project;
    }
}

