/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.maven.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connectivity.maven.api.model.ExecutionSummary;
import com.mulesoft.connectivity.maven.api.model.PhaseSummary;
import com.mulesoft.connectivity.maven.api.model.Status;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.project.MavenProject;

public class ExecutionReport
implements Closeable {
    private final Gson gson;
    private final File reportFile;
    private final ExecutionSummary executionSummary;

    public ExecutionReport(MavenProject project) throws IllegalArgumentException, IOException {
        block8: {
            this.gson = new GsonBuilder().setPrettyPrinting().create();
            this.reportFile = this.getReportFile(project);
            if (this.reportFile.exists()) {
                try (FileReader reader = new FileReader(this.reportFile);){
                    this.executionSummary = (ExecutionSummary)this.gson.fromJson((Reader)reader, ExecutionSummary.class);
                    break block8;
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Unexpected exception while reading the report file : " + String.valueOf(this.reportFile), ex);
                }
            }
            this.executionSummary = new ExecutionSummary(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getName());
            ExecutionReport.initializeExecutionSummary(project.getBuild().getDirectory(), this.reportFile, this.executionSummary);
        }
    }

    public void update(PhaseSummary summary) {
        this.executionSummary.getPhasesSummary().put(summary.getPhaseName(), summary);
        for (PhaseSummary entry : this.executionSummary.getPhasesSummary().values()) {
            if (!entry.getStatus().equals((Object)Status.FAILURE)) continue;
            this.executionSummary.setStatus(Status.FAILURE);
        }
    }

    @Override
    public void close() throws IOException {
        FileWriter writer = new FileWriter(this.reportFile);
        this.gson.toJson((Object)this.executionSummary, (Appendable)writer);
        writer.close();
    }

    private File getReportFile(MavenProject project) {
        return new File(String.format("%s/execution-report.json", project.getBuild().getDirectory()));
    }

    private static void initializeExecutionSummary(String buildPath, File reportFile, ExecutionSummary executionSummary) throws IOException {
        Files.createDirectories(Path.of(buildPath, new String[0]), new FileAttribute[0]);
        try (FileWriter fileWriter = new FileWriter(reportFile);){
            new Gson().toJson((Object)executionSummary, (Appendable)fileWriter);
        }
    }
}

