/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class Content
implements AutoCloseable {
    private final DataWeaveLiveValue liveValue;
    private final boolean serialize;

    Content(DataWeaveLiveValue liveValue) {
        this(liveValue, false);
    }

    Content(DataWeaveLiveValue liveValue, boolean serialize) {
        this.liveValue = liveValue;
        this.serialize = serialize;
    }

    public @Nullable Object get() {
        return this.liveValue.run("result");
    }

    public Optional<InputStream> raw() {
        String rawScript = this.serialize ? "write(result, result.^mimeType default 'application/json') as Binary" : "result.^raw";
        Object raw = this.liveValue.run(rawScript);
        return Optional.ofNullable(raw).filter(InputStream.class::isInstance).map(InputStream.class::cast);
    }

    public Optional<String> rawContentType() {
        return Optional.ofNullable((String)this.liveValue.run(this.serialize ? "result.^mimeType default 'application/json'" : "result.^mimeType"));
    }

    public Optional<Map<String, Object>> getTransportAttributes() {
        Object transportAttributes = this.liveValue.run("result.^transportAttributes");
        return Optional.ofNullable(transportAttributes).filter(Map.class::isInstance).map(Map.class::cast);
    }

    @Override
    public void close() {
        this.liveValue.close();
    }
}

