/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.metadata;

import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairMetadataValue;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectMetadataValue;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.VariableReferenceMetadataValue;
import org.mule.weave.v2.parser.location.WeaveLocation;

public class MetadataValueUtils {
    public static final String DEFAULT_METADATA_DESCRIPTION = "Some metadata";

    private MetadataValueUtils() {
    }

    public static List<KeyValuePairMetadataValue> asProperties(DWMetadataValue metadataValue) {
        return MetadataValueUtils.asProperties(metadataValue, DEFAULT_METADATA_DESCRIPTION);
    }

    public static List<KeyValuePairMetadataValue> asProperties(DWMetadataValue metadataValue, String what) {
        if (!(metadataValue instanceof ObjectMetadataValue)) {
            throw new InvalidConnectorException(what + " was supposed to be an object, but it's " + MetadataValueUtils.describeType(metadataValue) + " instead.", metadataValue.getLocation());
        }
        return List.of(((ObjectMetadataValue)metadataValue).getProperties());
    }

    public static Set<String> asSet(DWMetadataValue metadataValue) {
        return MetadataValueUtils.asSet(metadataValue, DEFAULT_METADATA_DESCRIPTION);
    }

    public static Set<String> asSet(DWMetadataValue metadataValue, String what) {
        if (!(metadataValue instanceof ArrayMetadataValue)) {
            throw new InvalidConnectorException(what + " was supposed to be an array, but it's " + MetadataValueUtils.describeType(metadataValue) + " instead.", metadataValue.getLocation());
        }
        return Stream.of(((ArrayMetadataValue)metadataValue).getElements()).map(mv -> MetadataValueUtils.asString(mv, what + " element")).collect(Collectors.toSet());
    }

    public static String asString(DWMetadataValue metadataValue) {
        return MetadataValueUtils.asString(metadataValue, DEFAULT_METADATA_DESCRIPTION);
    }

    public static String asString(DWMetadataValue metadataValue, String what) {
        LiteralMetadataValue literalMetadataValue;
        if (!(metadataValue instanceof LiteralMetadataValue) || !((literalMetadataValue = (LiteralMetadataValue)metadataValue).getType() instanceof StringType)) {
            throw new InvalidConnectorException(what + " was supposed to be a string, but it's " + MetadataValueUtils.describeType(metadataValue) + " instead.", metadataValue.getLocation());
        }
        return literalMetadataValue.getValue();
    }

    public static Boolean asBoolean(DWMetadataValue metadataValue) {
        LiteralMetadataValue literalMetadataValue;
        if (!(metadataValue instanceof LiteralMetadataValue) || !((literalMetadataValue = (LiteralMetadataValue)metadataValue).getType() instanceof BooleanType)) {
            throw new InvalidConnectorException("Metadata was supposed to be a boolean, but it's " + MetadataValueUtils.describeType(metadataValue) + " instead.", metadataValue.getLocation());
        }
        return Boolean.valueOf(literalMetadataValue.getValue());
    }

    public static Integer asInteger(DWMetadataValue metadataValue) {
        LiteralMetadataValue literalMetadataValue;
        if (!(metadataValue instanceof LiteralMetadataValue) || !((literalMetadataValue = (LiteralMetadataValue)metadataValue).getType() instanceof NumberType)) {
            throw new InvalidConnectorException("Metadata was supposed to be a number, but it's " + MetadataValueUtils.describeType(metadataValue) + " instead.", metadataValue.getLocation());
        }
        return Integer.valueOf(literalMetadataValue.getValue());
    }

    public static Optional<DWMetadataValue> getProperty(List<KeyValuePairMetadataValue> properties, String name) {
        return properties.stream().filter(kv -> kv.getKey().equals(name)).map(KeyValuePairMetadataValue::getValue).findFirst();
    }

    public static Optional<String> getStringProperty(List<KeyValuePairMetadataValue> properties, String name) {
        return MetadataValueUtils.getProperty(properties, name).map(MetadataValueUtils::asString);
    }

    public static String requireStringProperty(List<KeyValuePairMetadataValue> properties, String name) {
        return MetadataValueUtils.getStringProperty(properties, name).orElseThrow(() -> {
            WeaveLocation location = InvalidConnectorException.lastLocation(properties.stream().map(DWMetadataValue::getLocation).toList()).orElse(null);
            return new InvalidConnectorException("The '" + name + "' property is required.", (Location)location);
        });
    }

    public static boolean getBooleanProperty(List<KeyValuePairMetadataValue> properties, String name, boolean defaultValue) {
        return MetadataValueUtils.getProperty(properties, name).map(MetadataValueUtils::asBoolean).orElse(defaultValue);
    }

    public static String describeType(DWMetadataValue metadataValue) {
        if (metadataValue instanceof LiteralMetadataValue) {
            return "a " + ((LiteralMetadataValue)metadataValue).getType().toString().toLowerCase(Locale.ROOT);
        }
        if (metadataValue instanceof ArrayMetadataValue) {
            return "an array";
        }
        if (metadataValue instanceof VariableReferenceMetadataValue) {
            return "a reference to a variable";
        }
        if (metadataValue instanceof ObjectMetadataValue) {
            return "an object";
        }
        return metadataValue.getClass().getSimpleName();
    }
}

