/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.Page;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModelLoaderFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

class ModelInterpreter003Test {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();
    private static final LanguageModelLoader<TestConnectorModel, TestConnectorModel.Builder> modelLoader = new LanguageModelLoader(dataWeaveEngine, (ModelLoader)new TestConnectorModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"Metadata::TestConnector"));
    protected final ModelInterpreter modelInterpreter = new ModelInterpreter(dataWeaveEngine, new ModelInterpreterConfig.Builder().build());
    private static final TestConnectorModel CONNECTOR_MODEL = (TestConnectorModel)modelLoader.loadModule("test003::Connector");
    private static final Map<String, Object> connectionInfo = ModelInterpreter003Test.createConnectionInfo();

    ModelInterpreter003Test() {
    }

    private static Map<String, Object> createConnectionInfo() {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("baseUri", "http://api.acme.com/v1");
        connectionInfo.put("user", "jdoe");
        connectionInfo.put("pass", "secret");
        return connectionInfo;
    }

    @Test
    void testConnection() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        TestConnectionModel testConnectionModel = CONNECTOR_MODEL.getTestConnection();
        assert (testConnectionModel != null);
        ConnectionValidationResult result = this.modelInterpreter.testConnection(testConnectionModel, (BaseConnectionProviderModel)connectionProviderModel, connectionInfo);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)result.isValid(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void executesOperation() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("getUserByIdEndpoint");
        HashMap<Object, Object> cookie = new HashMap<Object, Object>();
        cookie.put("cookie1", "value1");
        cookie.put("cookie2", "value2");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, ModelInterpreter003Test.createGetUserByIdParams(1, "An employee", "X-mule", cookie));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Map getUserResult = (Map)operationResult.getValue();
        MatcherAssert.assertThat(getUserResult.get("contentType"), (Matcher)CoreMatchers.equalTo((Object)"application/json"));
        MatcherAssert.assertThat(getUserResult.get("status"), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat(getUserResult.get("headers"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        Map headers = (Map)getUserResult.get("headers");
        MatcherAssert.assertThat(getUserResult.get("body"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        ModelInterpreter003Test.assertGetUserById((Map)getUserResult.get("body"), 1, "An employee", "X-mule");
    }

    @Test
    void executesCustomOperation() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("getUserByIdCustom");
        OperationResult operationResult = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, ModelInterpreter003Test.createCustomGetUserByIdParams(1, "An employee", "X-mule"));
        MatcherAssert.assertThat((Object)operationResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)operationResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Map getUserResult = (Map)operationResult.getValue();
        MatcherAssert.assertThat(getUserResult.get("contentType"), (Matcher)CoreMatchers.equalTo((Object)"application/json"));
        MatcherAssert.assertThat(getUserResult.get("status"), (Matcher)CoreMatchers.equalTo((Object)200));
        MatcherAssert.assertThat(getUserResult.get("headers"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        Map headers = (Map)getUserResult.get("headers");
        MatcherAssert.assertThat(getUserResult.get("body"), (Matcher)IsInstanceOf.instanceOf(Map.class));
        ModelInterpreter003Test.assertGetUserById((Map)getUserResult.get("body"), 1, "An employee", "X-mule");
    }

    @Test
    void executesPaginatedOperation() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("getUsers");
        OperationResult page1 = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, ModelInterpreter003Test.createPaginationParams(2));
        MatcherAssert.assertThat((Object)page1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page1.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Page getAccountsResult = (Page)page1.getValue();
        MatcherAssert.assertThat((Object)getAccountsResult.getItems(), (Matcher)IsInstanceOf.instanceOf(List.class));
        List items = getAccountsResult.getItems();
        MatcherAssert.assertThat((Object)items, (Matcher)Matchers.hasSize((int)2));
        ModelInterpreter003Test.assertUser((Map)items.get(0), "1", "One", "one@acme.com");
        ModelInterpreter003Test.assertUser((Map)items.get(1), "2", "Two", "two@acme.com");
        this.assertNextPage((Map)getAccountsResult.getNextPage().orElseThrow(), 2, 2);
        OperationResult page2 = this.modelInterpreter.executeOperationNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, getAccountsResult.getNextPage().orElseThrow());
        MatcherAssert.assertThat((Object)page2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page2.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        getAccountsResult = (Page)page2.getValue();
        MatcherAssert.assertThat((Object)getAccountsResult.getItems(), (Matcher)IsInstanceOf.instanceOf(List.class));
        items = getAccountsResult.getItems();
        MatcherAssert.assertThat((Object)items, (Matcher)Matchers.hasSize((int)2));
        ModelInterpreter003Test.assertUser((Map)items.get(0), "3", "Three", "three@acme.com");
        ModelInterpreter003Test.assertUser((Map)items.get(1), "4", "Four", "four@acme.com");
        this.assertNextPage((Map)getAccountsResult.getNextPage().orElseThrow(), 4, 2);
        OperationResult page3 = this.modelInterpreter.executeOperationNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, getAccountsResult.getNextPage().orElseThrow());
        MatcherAssert.assertThat((Object)page3, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page3.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        getAccountsResult = (Page)page3.getValue();
        MatcherAssert.assertThat((Object)getAccountsResult.getItems().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        items = getAccountsResult.getItems();
        ModelInterpreter003Test.assertUser((Map)items.get(0), "5", "Five", "five@acme.com");
        ModelInterpreter003Test.assertUser((Map)items.get(1), "6", "Six", "six@acme.com");
    }

    @Test
    void executesPaginatedOperationWithDifferentSecondOperation() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        OperationModel operationModel = CONNECTOR_MODEL.getOperation("getUsers2");
        OperationResult page1 = this.modelInterpreter.executeOperation((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, ModelInterpreter003Test.createPaginationParams(2));
        MatcherAssert.assertThat((Object)page1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page1.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Page getAccountsResult = (Page)page1.getValue();
        MatcherAssert.assertThat((Object)getAccountsResult.getItems(), (Matcher)IsInstanceOf.instanceOf(List.class));
        List items = getAccountsResult.getItems();
        MatcherAssert.assertThat((Object)items, (Matcher)Matchers.hasSize((int)2));
        ModelInterpreter003Test.assertUser((Map)items.get(0), "1", "One", "one@acme.com");
        ModelInterpreter003Test.assertUser((Map)items.get(1), "2", "Two", "two@acme.com");
        this.assertNextPage((Map)getAccountsResult.getNextPage().orElseThrow(), 2, 2);
        OperationResult page2 = this.modelInterpreter.executeOperationNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, getAccountsResult.getNextPage().orElseThrow());
        MatcherAssert.assertThat((Object)page2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page2.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        getAccountsResult = (Page)page2.getValue();
        MatcherAssert.assertThat((Object)getAccountsResult.getItems(), (Matcher)IsInstanceOf.instanceOf(List.class));
        items = getAccountsResult.getItems();
        MatcherAssert.assertThat((Object)items, (Matcher)Matchers.hasSize((int)2));
        ModelInterpreter003Test.assertUser((Map)items.get(0), "3", "Three", "three@acme.com");
        ModelInterpreter003Test.assertUser((Map)items.get(1), "4", "Four", "four@acme.com");
        this.assertNextPage((Map)getAccountsResult.getNextPage().orElseThrow(), 4, 2);
        OperationResult page3 = this.modelInterpreter.executeOperationNextPage((BaseConnectionProviderModel)connectionProviderModel, connectionInfo, (BaseExecutableComponentModel)operationModel, getAccountsResult.getNextPage().orElseThrow());
        MatcherAssert.assertThat((Object)page3, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)page3.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        getAccountsResult = (Page)page3.getValue();
        MatcherAssert.assertThat((Object)getAccountsResult.getItems().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        items = getAccountsResult.getItems();
        ModelInterpreter003Test.assertUser((Map)items.get(0), "5", "Five", "five@acme.com");
        ModelInterpreter003Test.assertUser((Map)items.get(1), "6", "Six", "six@acme.com");
    }

    @Test
    void executesValueProvider() {
        ConnectionProviderModel connectionProviderModel = CONNECTOR_MODEL.getConnectionProviders().get(0);
        ValueProviderModel valueProvider = CONNECTOR_MODEL.getValueProvider("usersValueProvider");
        OperationResult executionResult = this.modelInterpreter.executeValueProvider(connectionProviderModel, connectionInfo, valueProvider, ModelInterpreter003Test.createPaginationParams(0, 2));
        MatcherAssert.assertThat((Object)executionResult, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)executionResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Page page = (Page)executionResult.getValue();
        List items = page.getItems();
        MatcherAssert.assertThat((Object)items, (Matcher)Matchers.hasSize((int)2));
        ModelInterpreter003Test.assertProvidedValue((ProvidedValue)items.get(0), "1", "One");
        ModelInterpreter003Test.assertProvidedValue((ProvidedValue)items.get(1), "2", "Two");
    }

    private static void assertGetUserById(Map<?, ?> value, int userId, String metadata, String customHeader) {
        MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat(value.get("userName"), (Matcher)CoreMatchers.equalTo((Object)"Test user name"));
        MatcherAssert.assertThat(value.get("surname"), (Matcher)CoreMatchers.equalTo((Object)"Test surname"));
        MatcherAssert.assertThat(value.get("age"), (Matcher)CoreMatchers.equalTo((Object)32));
        MatcherAssert.assertThat(((Map)value.get("metadata")).get("uri"), (Matcher)CoreMatchers.equalTo((Object)userId));
        MatcherAssert.assertThat(((Map)value.get("metadata")).get("query"), (Matcher)CoreMatchers.equalTo((Object)metadata));
        MatcherAssert.assertThat(((Map)value.get("metadata")).get("headers"), (Matcher)CoreMatchers.equalTo((Object)customHeader));
    }

    protected void assertNextPage(Map<?, ?> value, int offset, int limit) {
        MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        Map args = (Map)value.get("args");
        MatcherAssert.assertThat((Object)((Map)args.get("query")).size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat(((Map)args.get("query")).get("offset"), (Matcher)CoreMatchers.equalTo((Object)offset));
        MatcherAssert.assertThat(((Map)args.get("query")).get("limit"), (Matcher)CoreMatchers.equalTo((Object)limit));
    }

    private static void assertProvidedValue(ProvidedValue providedValue, String value, String label) {
        MatcherAssert.assertThat((Object)providedValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
        MatcherAssert.assertThat((Object)providedValue.getLabel(), (Matcher)CoreMatchers.is((Object)label));
    }

    private static Map<String, Map<String, Object>> createDefaultInputTypeParams() {
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("query", new HashMap());
        params.put("headers", new HashMap());
        params.put("cookie", new HashMap());
        return params;
    }

    private static Map<String, Map<String, Object>> createPaginationParams(int limit) {
        Map<String, Map<String, Object>> params = ModelInterpreter003Test.createDefaultInputTypeParams();
        params.get("query").put("limit", limit);
        return params;
    }

    private static Map<String, Map<String, Object>> createPaginationParams(int offset, int limit) {
        Map<String, Map<String, Object>> params = ModelInterpreter003Test.createDefaultInputTypeParams();
        params.get("query").put("offset", offset);
        params.get("query").put("limit", limit);
        return params;
    }

    private static Map<String, Map<String, Object>> createGetUserByIdParams(int userId, String metadata, String customHeader, Map<Object, Object> cookie) {
        Map<String, Map<String, Object>> params = ModelInterpreter003Test.createDefaultInputTypeParams();
        params.put("uri", Map.of("userId", userId));
        params.get("query").put("metadata", metadata);
        params.get("headers").put("customHeader", customHeader);
        cookie.forEach((key, value) -> ((Map)params.get("cookie")).put((String)key, value));
        return params;
    }

    private static Map<Object, Object> createCustomGetUserByIdParams(int userId, String metadata, String customHeader) {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("userId", userId);
        params.put("metadata", metadata);
        params.put("customHeader", customHeader);
        return params;
    }

    private static void assertUser(Map<?, ?> value, String id, String name, String email) {
        MatcherAssert.assertThat((Object)value.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(value.get("id"), (Matcher)CoreMatchers.equalTo((Object)id));
        MatcherAssert.assertThat(value.get("name"), (Matcher)CoreMatchers.equalTo((Object)name));
        MatcherAssert.assertThat(value.get("email"), (Matcher)CoreMatchers.equalTo((Object)email));
    }
}

