/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.model.CodeSourceLocation;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CodeSourceLocationTest {
    @Test
    public void canRepresentModules() {
        Assertions.assertTrue((boolean)CodeSourceLocation.module((String)"this::isA::module").isModuleReference());
        Assertions.assertFalse((boolean)CodeSourceLocation.module((String)"this::isA::module").isVariableReference());
        Assertions.assertFalse((boolean)CodeSourceLocation.module((String)"this::isA::module").isFieldReference());
    }

    @Test
    public void canRepresentVariables() {
        Assertions.assertFalse((boolean)CodeSourceLocation.module((String)"module").variable("myVar").isModuleReference());
        Assertions.assertTrue((boolean)CodeSourceLocation.module((String)"module").variable("myVar").isVariableReference());
        Assertions.assertFalse((boolean)CodeSourceLocation.module((String)"module").variable("myVar").isFieldReference());
    }

    @Test
    public void canRepresentFields() {
        Assertions.assertFalse((boolean)CodeSourceLocation.module((String)"module").variable("myVar").field("myField").isModuleReference());
        Assertions.assertFalse((boolean)CodeSourceLocation.module((String)"module").variable("myVar").field("myField").isVariableReference());
        Assertions.assertTrue((boolean)CodeSourceLocation.module((String)"module").variable("myVar").field("myField").isFieldReference());
    }

    @Test
    public void illegalModuleNamesAreDetected() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.module((String)"this::isA::/module"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.module((String)"this::isA").submodule("/module"));
    }

    @Test
    public void illegalVariableNamesAreDetected() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.module((String)"module").variable("my/variable"));
    }

    @Test
    public void fieldsRequireVariableOrFieldReferences() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CodeSourceLocation.module((String)"module").field("field"));
        Assertions.assertDoesNotThrow(() -> CodeSourceLocation.module((String)"module").variable("variable").field("field"));
        Assertions.assertDoesNotThrow(() -> CodeSourceLocation.module((String)"module").variable("variable").field("field").field("field"));
    }

    @Test
    public void variablesRequireModuleReferences() {
        Assertions.assertDoesNotThrow(() -> CodeSourceLocation.module((String)"module").variable("variable"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CodeSourceLocation.module((String)"module").variable("variable").variable("variable").variable("anotherVariable"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CodeSourceLocation.module((String)"module").variable("variable").variable("variable").field("field").variable("anotherVariable"));
    }

    @Test
    public void canDoSubmodules() {
        Assertions.assertEquals((Object)CodeSourceLocation.module((String)"my::module"), (Object)CodeSourceLocation.module((String)"my").submodule("module"));
    }

    @Test
    public void submodulesRequireModuleReferences() {
        Assertions.assertDoesNotThrow(() -> CodeSourceLocation.module((String)"my::module").submodule("submodule"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CodeSourceLocation.module((String)"my::module").variable("variable").submodule("submodule"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CodeSourceLocation.module((String)"my::module").variable("variable").field("field").submodule("submodule"));
    }

    @Test
    public void toStringDoesQuotingIfNeeded() {
        Assertions.assertEquals((Object)"module::variable.unquotedField", (Object)CodeSourceLocation.module((String)"module").variable("variable").field("unquotedField").toString());
        Assertions.assertEquals((Object)"module::variable.\"quoted field\"", (Object)CodeSourceLocation.module((String)"module").variable("variable").field("quoted field").toString());
    }

    @Test
    public void canGetTheParentForALocation() {
        CodeSourceLocation nestedLocation = CodeSourceLocation.module((String)"my::module").variable("variable").field("field").field("field2");
        Assertions.assertEquals((Object)CodeSourceLocation.module((String)"my::module").variable("variable").field("field"), (Object)nestedLocation.getParent());
        Assertions.assertEquals((Object)CodeSourceLocation.module((String)"my::module").variable("variable"), (Object)nestedLocation.getParent().getParent());
        Assertions.assertEquals((Object)CodeSourceLocation.module((String)"my::module"), (Object)nestedLocation.getParent().getParent().getParent());
        Assertions.assertEquals((Object)CodeSourceLocation.module((String)"my"), (Object)nestedLocation.getParent().getParent().getParent().getParent());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> nestedLocation.getParent().getParent().getParent().getParent().getParent());
    }

    @Test
    public void canCheckIfSomethingIsFieldOrVariable() {
        Assertions.assertThrows(IllegalStateException.class, () -> CodeSourceLocation.module((String)"my::module").submodule("submodule").assertFieldOrVariableReference());
        Assertions.assertDoesNotThrow(() -> CodeSourceLocation.module((String)"my::module").variable("variable").assertFieldOrVariableReference());
        Assertions.assertDoesNotThrow(() -> CodeSourceLocation.module((String)"my::module").variable("variable").field("field").assertFieldOrVariableReference());
    }

    @Test
    public void canAddAnnotationsToFieldsAndVariables() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> CodeSourceLocation.module((String)"module").withAnnotations(List.of()));
        Assertions.assertDoesNotThrow(() -> CodeSourceLocation.module((String)"module").variable("variable").withAnnotations(List.of()));
        Assertions.assertDoesNotThrow(() -> CodeSourceLocation.module((String)"module").variable("variable").field("field").withAnnotations(List.of()));
    }

    @Test
    public void annotationsShouldBeVariableReferences() {
        CodeSourceLocation module = CodeSourceLocation.module((String)"module");
        CodeSourceLocation variable = module.variable("variable");
        CodeSourceLocation field = variable.field("field");
        Assertions.assertThrows(IllegalArgumentException.class, () -> variable.withAnnotations(List.of(CodeSourceLocationTest.annotation(module))));
        Assertions.assertDoesNotThrow(() -> variable.withAnnotations(List.of(CodeSourceLocationTest.annotation(variable))));
        Assertions.assertThrows(IllegalArgumentException.class, () -> variable.withAnnotations(List.of(CodeSourceLocationTest.annotation(field))));
    }

    @Test
    public void canGetModule() {
        CodeSourceLocation nestedLocation = CodeSourceLocation.module((String)"my::module").variable("variable").field("field").field("field2");
        Assertions.assertEquals(List.of("my", "module"), (Object)nestedLocation.getModuleParts());
    }

    @Test
    public void canGetVariable() {
        CodeSourceLocation nestedLocation = CodeSourceLocation.module((String)"my::module").variable("variable").field("field").field("field2");
        Assertions.assertEquals((Object)"variable", (Object)nestedLocation.getVariableName());
        CodeSourceLocation variableLocation = CodeSourceLocation.module((String)"my::module").variable("variable");
        Assertions.assertEquals((Object)"variable", (Object)variableLocation.getVariableName());
        CodeSourceLocation moduleLocation = CodeSourceLocation.module((String)"my::module");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((CodeSourceLocation)moduleLocation).getVariableName());
    }

    @Test
    public void canGetField() {
        CodeSourceLocation nestedLocation = CodeSourceLocation.module((String)"my::module").variable("variable").field("field").field("field2");
        Assertions.assertEquals(List.of("field", "field2"), (Object)nestedLocation.getFieldParts());
    }

    @Test
    public void canGetVariableAndField() {
        CodeSourceLocation nestedLocation = CodeSourceLocation.module((String)"my::module").variable("variable").field("field").field("field2");
        Assertions.assertEquals(List.of("variable", "field", "field2"), (Object)nestedLocation.getVariableParts());
    }

    @Test
    public void canGetAllParts() {
        CodeSourceLocation nestedLocation = CodeSourceLocation.module((String)"my::module").variable("variable").field("field").field("field2");
        Assertions.assertEquals(List.of("my", "module", "variable", "field", "field2"), (Object)nestedLocation.getParts());
    }

    @Test
    public void canGetAnnotations() {
        CodeSourceLocation nestedLocation = CodeSourceLocation.module((String)"my::module").variable("variable").withAnnotations(List.of(CodeSourceLocationTest.annotation(CodeSourceLocation.module((String)"my::annotations").variable("annotation"))));
        Assertions.assertEquals(List.of(CodeSourceLocationTest.annotation(CodeSourceLocation.module((String)"my::annotations").variable("annotation"))), (Object)nestedLocation.getAnnotations());
    }

    @Test
    public void canAddAnnotationsOneByOne() {
        CodeSourceLocation annotation0 = CodeSourceLocation.module((String)"my::annotation").variable("Annotation0");
        CodeSourceLocation annotation1 = CodeSourceLocation.module((String)"my::annotation").variable("Annotation1");
        CodeSourceLocation variable = CodeSourceLocation.module((String)"my::module").variable("variable").addAnnotation(annotation0, Map.of(), true).addAnnotation(annotation1, Map.of(), true);
        Assertions.assertEquals(List.of(CodeSourceLocationTest.annotation(annotation0), CodeSourceLocationTest.annotation(annotation1)), (Object)variable.getAnnotations());
    }

    @Test
    public void canChangeParameterization() {
        CodeSourceLocation annotation = CodeSourceLocation.module((String)"my::annotation").variable("Annotation0");
        CodeSourceLocation variable = CodeSourceLocation.module((String)"my::module").variable("variable").addAnnotation(annotation, Map.of("test", 0), true);
        CodeSourceLocation variable2 = variable.withAnnotations(List.of(CodeSourceLocationTest.annotation(annotation, "test2", 1)));
        Assertions.assertEquals(List.of(CodeSourceLocationTest.annotation(annotation, "test", 0)), (Object)variable.getAnnotations());
        Assertions.assertEquals(List.of(CodeSourceLocationTest.annotation(annotation, "test2", 1)), (Object)variable2.getAnnotations());
    }

    @Test
    public void canAddMultipleAnnotations() {
        CodeSourceLocation annotation0 = CodeSourceLocation.module((String)"my::annotation").variable("Annotation0");
        CodeSourceLocation annotation1 = CodeSourceLocation.module((String)"my::annotation").variable("Annotation1");
        CodeSourceLocation annotation2 = CodeSourceLocation.module((String)"my::annotation").variable("Annotation2");
        CodeSourceLocation variable = CodeSourceLocation.module((String)"my::module").variable("variable").addAnnotation(annotation0, Map.of(), true).addAnnotations(List.of(CodeSourceLocationTest.annotation(annotation1), CodeSourceLocationTest.annotation(annotation2)));
        Assertions.assertEquals(List.of(CodeSourceLocationTest.annotation(annotation0), CodeSourceLocationTest.annotation(annotation1), CodeSourceLocationTest.annotation(annotation2)), (Object)variable.getAnnotations());
    }

    @Test
    public void canParseSimpleModelReferences() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::mulesoft::MyVariable");
        Assertions.assertTrue((boolean)location.isVariableReference());
        Assertions.assertEquals((Object)"MyVariable", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void canParseModeReferencesThatUseNonAlphabeticValidIdentifiers() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::Mulesoft::my_variable_0");
        Assertions.assertTrue((boolean)location.isVariableReference());
        Assertions.assertEquals((Object)"my_variable_0", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "Mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void canParseSimpleFieldReferences() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::mulesoft::MyVariable.myField");
        Assertions.assertTrue((boolean)location.isFieldReference());
        Assertions.assertEquals(List.of("myField"), (Object)location.getFieldParts());
        Assertions.assertEquals((Object)"MyVariable", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void canParseSimpleNestedFieldReferences() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::mulesoft::MyVariable.myField.mySubField.mySubSubField");
        Assertions.assertTrue((boolean)location.isFieldReference());
        Assertions.assertEquals(List.of("myField", "mySubField", "mySubSubField"), (Object)location.getFieldParts());
        Assertions.assertEquals((Object)"MyVariable", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void canParseFieldReferencesWithQuotedStrings() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::mulesoft::MyVariable.\"myField\"");
        Assertions.assertTrue((boolean)location.isFieldReference());
        Assertions.assertEquals(List.of("myField"), (Object)location.getFieldParts());
        Assertions.assertEquals((Object)"MyVariable", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void canParseFieldReferencesMixingIdentifiersAndQuotedStrings() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::mulesoft::MyVariable.\"myField\".otherField.\"otherOtherField\".otherOtherOtherField");
        Assertions.assertTrue((boolean)location.isFieldReference());
        Assertions.assertEquals(List.of("myField", "otherField", "otherOtherField", "otherOtherOtherField"), (Object)location.getFieldParts());
        Assertions.assertEquals((Object)"MyVariable", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void canParseFieldReferencesWithRegularEscapes() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::mulesoft::MyVariable.\"Regular escapes: \\\" \\/ \\\\ \\n \\b \\f \\r \\t \\$\"");
        Assertions.assertTrue((boolean)location.isFieldReference());
        Assertions.assertEquals(List.of("Regular escapes: \" / \\ \n \b \f \r \t $"), (Object)location.getFieldParts());
        Assertions.assertEquals((Object)"MyVariable", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void canParseFieldReferencesWithUnknownEscapes() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::mulesoft::MyVariable.\"Unknown escapes: \\W \\k \\?\"");
        Assertions.assertTrue((boolean)location.isFieldReference());
        Assertions.assertEquals(List.of("Unknown escapes: \\W \\k \\?"), (Object)location.getFieldParts());
        Assertions.assertEquals((Object)"MyVariable", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void canParseFieldReferencesWithCodepointEscapes() {
        CodeSourceLocation location = CodeSourceLocation.from((String)"com::mulesoft::MyVariable.\"Unicode codepoint: \\uFFFD \\ua66e\"");
        Assertions.assertTrue((boolean)location.isFieldReference());
        Assertions.assertEquals(List.of("Unicode codepoint: \ufffd \ua66e"), (Object)location.getFieldParts());
        Assertions.assertEquals((Object)"MyVariable", (Object)location.getVariableName());
        Assertions.assertEquals(List.of("com", "mulesoft"), (Object)location.getModuleParts());
    }

    @Test
    public void failsToParseOnBareModule() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com"));
    }

    @Test
    public void failsToParseOnRunawayString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::MyVariable.\"test"));
    }

    @Test
    public void failsToParseOnRunawayCodepointEscape() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::MyVariable.\"\\u12"));
    }

    @Test
    public void failsToParseOnRunawayModuleSeparator() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft:"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::"));
    }

    @Test
    public void failsToParseOnRunawayFieldSelector() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::MyVariable."));
    }

    @Test
    public void failsToParseOnIllegalIdentStart() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::$mulesoft::MyVariable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::$MyVariable"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::MyVariable.$field"));
    }

    @Test
    public void failsToParseOnIllegalIdentRestAtModulePart() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft$::MyVariable.field"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::MyVariable$.field"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::MyVariable.field$"));
    }

    @Test
    public void failsToParseOnIllegalCodepointEscape() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CodeSourceLocation.from((String)"com::mulesoft::MyVariable.\"\\u$$$$\""));
    }

    private static CodeSourceLocation.AnnotationInfo annotation(CodeSourceLocation annotation2) {
        return new CodeSourceLocation.AnnotationInfo(annotation2, Map.of(), true);
    }

    private static CodeSourceLocation.AnnotationInfo annotation(CodeSourceLocation annotation, String param0, Object value0) {
        return new CodeSourceLocation.AnnotationInfo(annotation, Map.of(param0, value0), true);
    }
}

