/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.operation.ErrorModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;

public class ErrorsDefinitionTest
extends AbstractConnectivityModelTest {
    private static final TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("error::Connector");

    @Test
    void errorValueWithOneErrorTypeOperation() {
        OperationModel operation = connectorModel.getOperation("errorValueWithOneErrorType");
        List errorModels = operation.getErrorDefinitions();
        MatcherAssert.assertThat((Object)WeaveTypeSimplifier.simplifyWeaveType((DWType)operation.getErrorOutputType().getDataType()), (Matcher)Matchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)errorModels.size(), (Matcher)Matchers.equalTo((Object)1));
        ErrorModel errorModel = (ErrorModel)errorModels.get(0);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"LEFT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
    }

    @Test
    void errorValueWithOneErrorTypeTrigger() {
        TriggerModel trigger = connectorModel.getTrigger("getUsersTriggerOneErrorTypes");
        List errorModels = trigger.getErrorDefinitions();
        MatcherAssert.assertThat((Object)WeaveTypeSimplifier.simplifyWeaveType((DWType)trigger.getErrorOutputType().getDataType()), (Matcher)Matchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)errorModels.size(), (Matcher)Matchers.equalTo((Object)1));
        ErrorModel errorModel = (ErrorModel)errorModels.get(0);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"LEFT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
    }

    @Test
    void errorValueWithMultipleErrorTypesOperation() {
        OperationModel operation = connectorModel.getOperation("errorValueWithMultipleErrorTypes");
        List errorModels = operation.getErrorDefinitions();
        MatcherAssert.assertThat((Object)WeaveTypeSimplifier.simplifyWeaveType((DWType)operation.getErrorOutputType().getDataType()), (Matcher)Matchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)errorModels.size(), (Matcher)Matchers.equalTo((Object)2));
        ErrorModel errorModel = (ErrorModel)errorModels.get(0);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"LEFT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
        errorModel = (ErrorModel)errorModels.get(1);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"RIGHT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
    }

    @Test
    void errorValueWithMultipleErrorTypesTrigger() {
        TriggerModel trigger = connectorModel.getTrigger("getUsersTriggerMultipleErrorTypes");
        List errorModels = trigger.getErrorDefinitions();
        MatcherAssert.assertThat((Object)WeaveTypeSimplifier.simplifyWeaveType((DWType)trigger.getErrorOutputType().getDataType()), (Matcher)Matchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)errorModels.size(), (Matcher)Matchers.equalTo((Object)2));
        ErrorModel errorModel = (ErrorModel)errorModels.get(0);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"LEFT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
        errorModel = (ErrorModel)errorModels.get(1);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"RIGHT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
    }

    @Test
    void multipleErrorValuesWithMultipleErrorTypesOperation() {
        OperationModel operation = connectorModel.getOperation("multipleErrorValuesWithMultipleErrorTypes");
        List errorModels = operation.getErrorDefinitions();
        MatcherAssert.assertThat((Object)WeaveTypeSimplifier.simplifyWeaveType((DWType)operation.getErrorOutputType().getDataType()), (Matcher)Matchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)errorModels.size(), (Matcher)Matchers.equalTo((Object)3));
        ErrorModel errorModel = (ErrorModel)errorModels.get(0);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"LEFT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
        errorModel = (ErrorModel)errorModels.get(1);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"RIGHT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
        errorModel = (ErrorModel)errorModels.get(2);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"UNKNOWN"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    void multipleErrorValuesWithMultipleErrorTypesTrigger() {
        TriggerModel trigger = connectorModel.getTrigger("getUsersTriggerMultipleValuesMultipleErrorTypes");
        List errorModels = trigger.getErrorDefinitions();
        MatcherAssert.assertThat((Object)WeaveTypeSimplifier.simplifyWeaveType((DWType)trigger.getErrorOutputType().getDataType()), (Matcher)Matchers.instanceOf(ObjectType.class));
        MatcherAssert.assertThat((Object)errorModels.size(), (Matcher)Matchers.equalTo((Object)3));
        ErrorModel errorModel = (ErrorModel)errorModels.get(0);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"LEFT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
        errorModel = (ErrorModel)errorModels.get(1);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"RIGHT"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)"INVALID_PARAMETER"));
        errorModel = (ErrorModel)errorModels.get(2);
        MatcherAssert.assertThat((Object)errorModel.getErrorType().getDataType(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)errorModel.getCategories().size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)errorModel.getKind(), (Matcher)Matchers.equalTo((Object)"UNKNOWN"));
        MatcherAssert.assertThat((Object)((String)errorModel.getCategories().get(0)), (Matcher)Matchers.equalTo((Object)""));
    }
}

