/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

class DataWeaveCallTest {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();

    DataWeaveCallTest() {
    }

    @Test
    public void bind() {
        try (DataWeaveCall call = this.getCall();){
            call.bind("aNumber", (Object)123);
            Object res = call.write("aNumber");
            MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Object)123));
        }
    }

    @Test
    public void bindConnection() {
        try (DataWeaveCall call = this.getCall();){
            ConnectionProviderModel provider = (ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)new ConnectionProviderModel.Builder().withModelReference("{ connect: (z: Any) -> z.username}")).inputType((TypeModel)new TypeModel.Builder().withDataType((DWType)TestUtils.EMPTY_OBJECT).build())).name("SomeConnection")).build();
            Map<String, String> info = Map.of("username", "pepe");
            Connection c = Connection.of((BaseConnectionProviderModel)provider, info);
            call.bind("connection", (Object)c);
            Object res = call.write("connection");
            MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Object)"pepe"));
        }
    }

    private DataWeaveCall getCall() {
        return new DataWeaveCall(new ModelInterpreterConfig.Builder().build(), dataWeaveEngine, this::getCall);
    }
}

