/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.test;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class OptionalMatchers {
    public static <T> Matcher<Optional<T>> isEmpty() {
        return new TypeSafeMatcher<Optional<T>>(){

            public void describeTo(Description description) {
                description.appendText("an empty Optional");
            }

            protected void describeMismatchSafely(Optional<T> item, Description mismatchDescription) {
                mismatchDescription.appendText("was an Optional with value ").appendValue(item);
            }

            protected boolean matchesSafely(Optional<T> item) {
                return item.isEmpty();
            }
        };
    }

    public static <T> Matcher<Optional<? extends T>> isPresentAnd(final Matcher<? super T> matcher) {
        return new TypeSafeMatcher<Optional<? extends T>>(){

            public void describeTo(Description description) {
                description.appendText("a non-empty Optional whose value ");
                description.appendDescriptionOf((SelfDescribing)matcher);
            }

            protected void describeMismatchSafely(Optional<? extends T> item, Description mismatchDescription) {
                mismatchDescription.appendText("was ");
                if (item.isEmpty()) {
                    mismatchDescription.appendText("an empty Optional");
                } else {
                    mismatchDescription.appendText("an Optional with value ").appendValue(item);
                }
            }

            protected boolean matchesSafely(Optional<? extends T> item) {
                return item.map(arg_0 -> ((Matcher)matcher).matches(arg_0)).orElse(false);
            }
        };
    }
}

