%dw 2.8

import TestConnectionElement from com::mulesoft::connectivity::Metadata

import defineTestConnection from com::mulesoft::connectivity::Model

import mapInputOperation from com::mulesoft::connectivity::decorator::Operation

import getBanner from ccm::jira::Operations

@TestConnectionElement()
var test = {
  validate: defineTestConnection(mapInputOperation(getBanner, (param: {}) -> {
    query: {},
    headers: {},
    cookie: {}
  }), (response) -> {
    isValid: response.value.status == 200,
    message: 
      if (response.success is true)
        "Connection test succeeded"
      else
        ++("Connection test failed - Http status code: ", response.value.status),
    (error: write(response.value.body, "application/dw") as String) if (response.success is false)
  })
}

