%dw 2.8

import * from com::mulesoft::connectivity::Model
import TestConnector from Metadata

type Item = {
    description: String,
    amount: Number
}

type Invoice = {
    items: Array<Item>,
    total: Number
}

var GetInvoicesDetailsById : Operation<{id: Number}, Invoice, ResultFailure, Connection> = {
    name: "GetInvoicesDetailsById",
    displayName: "GetInvoicesDetailsById",
    executor: (params, c) -> success({items: [{description: "one", amount: 50}, {description: "two", amount: 50}], total: 100})
}

@TestConnector()
var connector = {
    name: "X",
    displayName: "X",
    connections: {
        c: {
            connect: (x: Object) -> {},
            authenticationType: {}
        }
    },
    operations: {
        GetInvoicesDetailsById: GetInvoicesDetailsById
    }
}