/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.parser.ast.QName;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.BooleanType;
import org.mule.weave.v2.ts.KeyType;
import org.mule.weave.v2.ts.KeyValuePairType;
import org.mule.weave.v2.ts.NameType;
import org.mule.weave.v2.ts.NullType;
import org.mule.weave.v2.ts.NumberType;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TypeUtilsTestCase {
    private static final String STRING = "String";
    private static final String BOOLEAN = "Boolean";
    private static final String NUMBER = "Number";
    private static final String NULL = "Null";
    private static final String OBJECT = "Object";
    private static final String ARRAY = "Array";
    private static final String UNION = "Union";
    private static final WeaveType wt = (WeaveType)Mockito.mock(WeaveType.class);

    @Test
    public void translatePrimitiveTypeValueDefinition() {
        DWType stringMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", STRING));
        DWType stringDateMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", STRING, "format", "date"));
        DWType stringDateTimeMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", STRING, "format", "date-time"));
        List<Map<String, String>> enumStringValues = List.of(Map.of("id", "account", "label", "Account"), Map.of("id", "order", "label", "Order"));
        DWType enumStringMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", STRING, "values", enumStringValues));
        DWType booleanMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", BOOLEAN));
        DWType numberMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", NUMBER));
        DWType numberIntMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", NUMBER, "format", "integer"));
        DWType numberDoubleMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", NUMBER, "format", "double"));
        DWType numberFloatMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", NUMBER, "format", "float"));
        List<Map<String, String>> enumNumberValues = List.of(Map.of("value", 1), Map.of("value", 2, "label", "dos"), Map.of("value", 3, "label", "three"));
        DWType enumNumberMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", NUMBER, "values", enumNumberValues));
        DWType nullMetadataType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", NULL));
        MatcherAssert.assertThat((Object)stringMetadataType, (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)stringDateMetadataType, (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)MetadataUtils.requireFormat((DWType)stringDateMetadataType), (Matcher)Matchers.equalTo((Object)"date"));
        MatcherAssert.assertThat((Object)stringDateTimeMetadataType, (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)MetadataUtils.requireFormat((DWType)stringDateTimeMetadataType), (Matcher)Matchers.equalTo((Object)"date-time"));
        Optional enumValuesOptional = MetadataUtils.getEnumValues((DWType)enumStringMetadataType);
        Assertions.assertTrue((boolean)enumValuesOptional.isPresent());
        Assertions.assertEquals((int)2, (int)((List)enumValuesOptional.get()).size());
        TestUtils.assertEnumLabels(enumStringMetadataType, List.of("Account", "Order"));
        MatcherAssert.assertThat((Object)MetadataUtils.requireFormat((DWType)numberIntMetadataType), (Matcher)Matchers.equalTo((Object)"integer"));
        MatcherAssert.assertThat((Object)MetadataUtils.requireFormat((DWType)numberDoubleMetadataType), (Matcher)Matchers.equalTo((Object)"double"));
        MatcherAssert.assertThat((Object)MetadataUtils.requireFormat((DWType)numberFloatMetadataType), (Matcher)Matchers.equalTo((Object)"float"));
        MatcherAssert.assertThat((Object)booleanMetadataType, (Matcher)Matchers.instanceOf(BooleanType.class));
        MatcherAssert.assertThat((Object)numberMetadataType, (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)enumNumberMetadataType, (Matcher)Matchers.instanceOf(NumberType.class));
        Assertions.assertEquals((int)3, (int)MetadataUtils.requireEnumValues((DWType)enumNumberMetadataType).size());
        TestUtils.assertEnumLabels(enumNumberMetadataType, List.of("1", "dos", "three"));
        MatcherAssert.assertThat((Object)nullMetadataType, (Matcher)Matchers.instanceOf(NullType.class));
    }

    @Test
    public void translateObjectTypeValueDefinition() {
        Map<String, Map<String, List<String>>> field = Map.of("name", Map.of("localName", "orderId"), "required", true, "repeated", false, "value", Map.of("type", NUMBER), "annotations", Map.of("label", "id", "description", "Description", "operators", List.of("op1", "op2")));
        DWType objectDefinitionType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", OBJECT, "name", "Order", "fields", List.of(field)));
        MatcherAssert.assertThat((Object)objectDefinitionType, (Matcher)Matchers.instanceOf(ObjectType.class));
        TestUtils.assertTypeId(objectDefinitionType, "Order");
        Assertions.assertEquals((int)1, (int)((ObjectType)objectDefinitionType).getProperties().length);
        org.mule.weave.v2.api.tooling.ts.KeyValuePairType orderIdField = Stream.of(((ObjectType)objectDefinitionType).getProperties()).filter(property -> DWTypeUtils.getKey((org.mule.weave.v2.api.tooling.ts.KeyValuePairType)property).equals("orderId")).findFirst().orElseThrow();
        String orderIdFieldLabel = MetadataUtils.requireLabel((DWType)orderIdField);
        MatcherAssert.assertThat((Object)orderIdFieldLabel, (Matcher)Matchers.equalTo((Object)"id"));
        String orderIdFieldDescription = MetadataUtils.requireDescription((DWType)orderIdField);
        MatcherAssert.assertThat((Object)orderIdFieldDescription, (Matcher)Matchers.equalTo((Object)"Description"));
        DWMetadata operators = (DWMetadata)MetadataUtils.getMetadata((DWType)orderIdField, (String)"operators").get();
        MatcherAssert.assertThat((Object)((ArrayMetadataValue)operators.getValue()).getElements().length, (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void translateArrayTypeValueDefinition() {
        DWType arrayDefinitionType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", ARRAY, "item", Map.of("type", STRING)));
        MatcherAssert.assertThat((Object)arrayDefinitionType, (Matcher)Matchers.instanceOf(ArrayType.class));
        WeaveType generic = ((ArrayType)arrayDefinitionType).of();
        MatcherAssert.assertThat((Object)generic, (Matcher)Matchers.instanceOf(StringType.class));
    }

    @Test
    public void translateUnionTypeValueDefinition() {
        DWType unionDefinitionType = TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", UNION, "types", List.of(Map.of("type", STRING), Map.of("type", NULL))));
        MatcherAssert.assertThat((Object)unionDefinitionType, (Matcher)Matchers.instanceOf(UnionType.class));
        List<DWType> types = List.of(((UnionType)unionDefinitionType).unionOf());
        MatcherAssert.assertThat((Object)types.get(0), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)types.get(1), (Matcher)Matchers.instanceOf(NullType.class));
    }

    @Test
    public void translateEmptyUnionTypeValueDefinition() {
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", UNION, "types", List.of())));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Union needs at least one type"));
    }

    @Test
    public void invalidDiscriminator() {
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TypeUtils.resolveWeaveType(extendedType -> wt, Map.of("type", "INVALID_TYPE")));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot translate type : INVALID_TYPE"));
    }

    @Test
    public void getUniqueFieldFromUnionType() {
        KeyValuePairType myField1 = this.getKeyValuePair("myField1", (WeaveType)NumberType.apply((Option)Option.empty()), false, false);
        KeyValuePairType myField2 = this.getKeyValuePair("myField2", (WeaveType)NumberType.apply((Option)Option.empty()), false, false);
        List<KeyValuePairType> objectKeyValuePairs = List.of(myField1, myField2);
        ObjectType objectType1 = new ObjectType((Seq)JavaConverters.asScalaBuffer(objectKeyValuePairs).seq(), true, true);
        myField1 = this.getKeyValuePair("theirField1", (WeaveType)StringType.apply((Option)Option.empty()), false, false);
        myField2 = this.getKeyValuePair("theirField2", (WeaveType)StringType.apply((Option)Option.empty()), false, false);
        objectKeyValuePairs = List.of(myField1, myField2);
        ObjectType objectType2 = ObjectType.apply((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(objectKeyValuePairs.iterator()).asScala()).toSeq(), (boolean)true, (boolean)false);
        List<ObjectType> unionTypes = List.of(objectType1, objectType2);
        UnionType unionType = UnionType.apply((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(unionTypes.iterator()).asScala()).toSeq());
        Optional myField = TypeUtils.getObjectPropertyType((DWType)unionType, (String)"myField1");
        Assertions.assertTrue((boolean)myField.isPresent());
        Assertions.assertTrue((boolean)(myField.get() instanceof NumberType));
    }

    @Test
    public void getRepeatedFieldFromUnionType() {
        KeyValuePairType myField1 = this.getKeyValuePair("myField1", (WeaveType)NumberType.apply((Option)Option.empty()), false, false);
        KeyValuePairType myField2 = this.getKeyValuePair("myField2", (WeaveType)NumberType.apply((Option)Option.empty()), false, false);
        List<KeyValuePairType> objectKeyValuePairs = List.of(myField1, myField2);
        ObjectType objectType1 = ObjectType.apply((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(objectKeyValuePairs.iterator()).asScala()).toSeq(), (boolean)true, (boolean)true);
        KeyValuePairType anotherMyField1 = this.getKeyValuePair("myField1", (WeaveType)StringType.apply((Option)Option.empty()), false, false);
        myField2 = this.getKeyValuePair("theirField2", (WeaveType)NumberType.apply((Option)Option.empty()), false, false);
        objectKeyValuePairs = List.of(anotherMyField1, myField2);
        ObjectType objectType2 = ObjectType.apply((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(objectKeyValuePairs.iterator()).asScala()).toSeq(), (boolean)true, (boolean)true);
        List<ObjectType> unionTypes = List.of(objectType1, objectType2);
        UnionType unionType = UnionType.apply((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(unionTypes.iterator()).asScala()).toSeq());
        Optional myField = TypeUtils.getObjectPropertyType((DWType)unionType, (String)"myField1");
        Assertions.assertTrue((boolean)myField.isPresent());
        Assertions.assertTrue((boolean)(myField.get() instanceof UnionType));
        List types = JavaConverters.seqAsJavaList((Seq)((UnionType)myField.get()).of());
        Assertions.assertTrue((boolean)((WeaveType)types.get(0)).equals(myField1.value()));
        Assertions.assertTrue((boolean)((WeaveType)types.get(1)).equals(anotherMyField1.value()));
    }

    private KeyValuePairType getKeyValuePair(String propertyName, WeaveType value, boolean optional, boolean repeated) {
        KeyType keyTypeT = new KeyType((WeaveType)new NameType(Option.apply((Object)new QName(propertyName, Option.empty()))), (Seq)JavaConverters.asScalaBuffer(new ArrayList()).seq());
        return new KeyValuePairType((WeaveType)keyTypeT, value, optional, repeated);
    }
}

