/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.operation;

import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class OperationResultTest {
    OperationResultTest() {
    }

    @Test
    public void success() {
        OperationResult res = OperationResult.success((Object)123);
        MatcherAssert.assertThat((Object)((Integer)res.getValue()), (Matcher)CoreMatchers.is((Object)123));
        MatcherAssert.assertThat((Object)res.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Assertions.assertThrows(IllegalStateException.class, () -> ((OperationResult)res).getErrorValue());
        MatcherAssert.assertThat((Object)((Integer)res.map(n -> n * 10).getValue()), (Matcher)CoreMatchers.is((Object)1230));
        MatcherAssert.assertThat((Object)((Integer)res.orElseThrow(e -> new RuntimeException())), (Matcher)CoreMatchers.is((Object)123));
        MatcherAssert.assertThat((Object)((Integer)res.or(e -> OperationResult.success((Object)321)).getValue()), (Matcher)CoreMatchers.is((Object)123));
    }

    @Test
    public void failure() {
        OperationResult res = OperationResult.failure((ResultError)ResultError.error((Object)123, (String)"INVALID", List.of("CLIENT_ERROR")));
        Assertions.assertThrows(IllegalStateException.class, () -> ((OperationResult)res).getValue());
        MatcherAssert.assertThat((Object)res.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)res.getErrorValue().getValue(), (Matcher)CoreMatchers.is((Object)123));
        MatcherAssert.assertThat((Object)res.map(n -> n * 10).getErrorValue().getValue(), (Matcher)CoreMatchers.is((Object)123));
        RuntimeException ex = new RuntimeException();
        AtomicInteger errValue = new AtomicInteger();
        RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> res.orElseThrow(err -> {
            errValue.set((Integer)err.getValue());
            return ex;
        }));
        MatcherAssert.assertThat((Object)thrown, (Matcher)Matchers.sameInstance((Object)ex));
        MatcherAssert.assertThat((Object)errValue.get(), (Matcher)CoreMatchers.is((Object)123));
        MatcherAssert.assertThat((Object)((Integer)res.or(e -> OperationResult.success((Object)321)).getValue()), (Matcher)CoreMatchers.is((Object)321));
    }
}

