/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.LazyPage;
import com.mulesoft.connectivity.linkweave.api.interpreter.LazyTriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextPoll;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LazyTriggerPage
extends LazyPage<LazyTriggerItem>
implements TriggerPage<LazyTriggerItem> {
    private final NextPoll nextPoll;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private boolean closed = false;

    public LazyTriggerPage(DataWeaveLiveValue liveValue) {
        super(liveValue);
        Serializable greatestWatermarkEncoded = (Serializable)liveValue.run("result.nextPoll.greatestWatermark");
        Serializable latestWatermarkEncoded = (Serializable)liveValue.run("result.nextPoll.latestWatermark");
        this.nextPoll = new NextPoll(greatestWatermarkEncoded, latestWatermarkEncoded);
    }

    @Override
    protected LazyTriggerItem getItem(DataWeaveCall call) {
        DataWeaveLiveValue value = call.execute("result.items[i]");
        this.closeables.add(value);
        return new LazyTriggerItem(value);
    }

    @Override
    public NextPoll getNextPoll() {
        return this.nextPoll;
    }

    @Override
    public NextData getNextData() {
        return new NextData(this.getNextPoll(), this.getNextPage().orElse(null));
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Exception primaryException = null;
        try {
            super.close();
        }
        catch (Exception e) {
            primaryException = new RuntimeException(e);
        }
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (primaryException == null) {
                    primaryException = e;
                    continue;
                }
                primaryException.addSuppressed(e);
            }
        }
        this.closed = true;
        if (primaryException != null) {
            throw new IllegalStateException("Exception while closing LazyTriggerPage", primaryException);
        }
    }
}

