/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.persistence.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mulesoft.connectivity.linkweave.api.loader.impl.CanonicalConnectivityModelLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.model.CanonicalConnectivityModel;
import com.mulesoft.connectivity.linkweave.api.persistence.gson.CanonicalConnectivityModelTypeAdapter;
import com.mulesoft.connectivity.linkweave.api.persistence.gson.WeaveTypeCatalogCollector;
import com.mulesoft.connectivity.linkweave.api.persistence.gson.WeaveTypeCatalogTypeAdapter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;

public class CanonicalConnectivityModelTypeAdapterTest {
    CanonicalConnectivityModel ccm = new CanonicalConnectivityModelLoaderImpl().load(List.of("ccm::jira::Types", "ccm::jira::Operations", "ccm::jira::OperationTypes", "ccm::jira::TestConnection", "ccm::jira::Connections"));

    @Test
    public void shouldSerializeCanonicalConnectivityModel() throws URISyntaxException, IOException {
        JsonElement actual;
        URL resourceUrl = CanonicalConnectivityModelTypeAdapterTest.class.getResource("/ccm/jira/serializedModel.json");
        String expectedText = Files.readString(Paths.get(resourceUrl.toURI()));
        WeaveTypeCatalogCollector catalogCollector = new WeaveTypeCatalogCollector();
        CanonicalConnectivityModelTypeAdapter typeAdapter = new CanonicalConnectivityModelTypeAdapter(catalogCollector);
        Gson gson = new GsonBuilder().registerTypeAdapter(CanonicalConnectivityModel.class, (Object)typeAdapter).registerTypeHierarchyAdapter(DWType.class, (Object)new WeaveTypeCatalogTypeAdapter(catalogCollector)).create();
        JsonElement expected = (JsonElement)gson.fromJson(expectedText, JsonObject.class);
        if (!expected.equals(actual = gson.toJsonTree((Object)this.ccm))) {
            try {
                Object actualFile = String.valueOf(Paths.get(resourceUrl.toURI())) + ".actual";
                actualFile = ((String)actualFile).replace("/target/test-classes/", "/src/test/resources/");
                System.err.println("Writing actual content to " + (String)actualFile);
                Files.writeString(Paths.get((String)actualFile, new String[0]), (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson(actual), new OpenOption[0]);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }
}

