/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.loader.CanonicalConnectivityModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.loader.impl.CanonicalConnectivityModelLoaderImpl;
import com.mulesoft.connectivity.linkweave.api.model.CanonicalConnectivityModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

public class CanonicalConnectivityModelLoaderTest {
    @Test
    public void loadingTest() {
        CanonicalConnectivityModelLoaderImpl ccmLoader = new CanonicalConnectivityModelLoaderImpl();
        CanonicalConnectivityModel ccm = ccmLoader.load(List.of("ccm::jira::Types", "ccm::jira::Operations", "ccm::jira::OperationTypes", "ccm::jira::TestConnection", "ccm::jira::Connections"));
        Assertions.assertEquals((int)ccm.getOperations().size(), (int)2);
        Assertions.assertTrue((boolean)((OperationModel)ccm.getOperations().get(0)).getModelReference().isPresent());
        Assertions.assertEquals(((OperationModel)ccm.getOperations().get(0)).getModelReference().get(), (Object)"ccm::jira::Operations::setBanner");
        Assertions.assertTrue((boolean)((OperationModel)ccm.getOperations().get(1)).getModelReference().isPresent());
        Assertions.assertEquals(((OperationModel)ccm.getOperations().get(1)).getModelReference().get(), (Object)"ccm::jira::Operations::getBanner");
        Assertions.assertEquals((int)ccm.getConnectionProviders().size(), (int)2);
        Assertions.assertTrue((boolean)((ConnectionProviderModel)ccm.getConnectionProviders().get(0)).getModelReference().isPresent());
        Assertions.assertEquals(((ConnectionProviderModel)ccm.getConnectionProviders().get(0)).getModelReference().get(), (Object)"ccm::jira::Connections::OAuth2");
        Assertions.assertTrue((boolean)((ConnectionProviderModel)ccm.getConnectionProviders().get(1)).getModelReference().isPresent());
        Assertions.assertEquals(((ConnectionProviderModel)ccm.getConnectionProviders().get(1)).getModelReference().get(), (Object)"ccm::jira::Connections::basicAuth");
        Assertions.assertNotNull((Object)ccm.getTestConnection());
        Assertions.assertTrue((boolean)ccm.getTestConnection().isPresent());
        Assertions.assertTrue((boolean)((TestConnectionModel)ccm.getTestConnection().get()).getModelReference().isPresent());
        Assertions.assertEquals(((TestConnectionModel)ccm.getTestConnection().get()).getModelReference().get(), (Object)"ccm::jira::TestConnection::test");
    }

    @Test
    public void testLoadingInvalidModule() {
        CanonicalConnectivityModelLoaderImpl ccmLoader = new CanonicalConnectivityModelLoaderImpl();
        Assertions.assertThrows(RuntimeException.class, () -> CanonicalConnectivityModelLoaderTest.lambda$testLoadingInvalidModule$0((CanonicalConnectivityModelLoader)ccmLoader));
    }

    @Test
    public void loadPaginatedOperation() {
        CanonicalConnectivityModelLoaderImpl ccmLoader = new CanonicalConnectivityModelLoaderImpl();
        CanonicalConnectivityModel ccm = ccmLoader.load(List.of("referenceProcessor::Module"));
        OperationModel getAccountsOperation = ccm.getOperation("getAccounts");
        Assertions.assertTrue((boolean)getAccountsOperation.isPaginated());
        DWType outputType = getAccountsOperation.getOutputType().getDataType();
        Assertions.assertTrue((boolean)(outputType instanceof ArrayType));
        Assertions.assertTrue((boolean)(TypeUtils.resolveReferenceType((DWType)((ArrayType)outputType).arrayOf()) instanceof ObjectType));
    }

    @Test
    public void loadTrigger() {
        CanonicalConnectivityModelLoaderImpl ccmLoader = new CanonicalConnectivityModelLoaderImpl();
        CanonicalConnectivityModel ccm = ccmLoader.load(List.of("referenceProcessor::Module"));
        List triggers = ccm.getTriggers();
        Assertions.assertEquals((int)1, (int)triggers.size());
        Assertions.assertEquals((Object)((TriggerModel)triggers.get(0)).getName(), (Object)"getUsersTrigger");
    }

    private static /* synthetic */ void lambda$testLoadingInvalidModule$0(CanonicalConnectivityModelLoader ccmLoader) throws Throwable {
        ccmLoader.load(List.of("some::wrong::Module"));
    }
}

