%dw 2.8

import Error, ResultFailure from com::mulesoft::connectivity::Model

import HttpRequestType, HttpResponse, NoContentHttpResponse from com::mulesoft::connectivity::transport::Http

import AnnouncementBannerConfiguration, AnnouncementBannerConfigurationUpdate, ErrorCollection from ccm::jira::Types

type getBannerType = {
  "200": HttpResponse<AnnouncementBannerConfiguration>,
  "401": HttpResponse<ErrorCollection>,
  "403": HttpResponse<ErrorCollection>,
  errorResponse: ResultFailure<getBannerType."401", Error<"status-401", "CLIENT_ERROR">> | ResultFailure<getBannerType."403", Error<"status-403", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{| query: Object, headers: Object, cookie: Object |}>,
  response: getBannerType."200"
}

type setBannerType = {
  "204": NoContentHttpResponse,
  "400": HttpResponse<ErrorCollection>,
  "401": HttpResponse<ErrorCollection>,
  "403": HttpResponse<ErrorCollection>,
  errorResponse: ResultFailure<setBannerType."400", Error<"status-400", "CLIENT_ERROR">> | ResultFailure<setBannerType."401", Error<"status-401", "CLIENT_ERROR">> | ResultFailure<setBannerType."403", Error<"status-403", "CLIENT_ERROR">> | ResultFailure<HttpResponse<Any>, Error<"status-unexpected", String>>,
  request: HttpRequestType<{| query: Object, headers: Object, cookie: Object, body: AnnouncementBannerConfigurationUpdate |}>,
  response: setBannerType."204"

}
