%dw 2.7

import TestConnector from Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::ValueProvider
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::metadata::Builder

import * from test001::Module

// Just a custom operation at the connector level
var getMessages : Operation<Null, HttpResponse<{messages: Array<String>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getMessages",
    displayName: "Get Messages",
        executor: (parameter, connection) -> success({
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {},
                body: {messages: ["Hello", "Good bye"]} <~ {mimeType: "application/json; charset=utf-8", raw: "" as Binary {base: "64"}}
        })
}

var accountsValueProvider = defineValueProvider(getAccounts.executor,
	(response: HttpResponse<{items: Array<Account>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name }}))

var accountsPaginatedValueProvider
= definePaginatedValueProvider(getAccountsPaginated.executor,
(page: Page<Account, {offset: Number,limit: Number}>) ->
    page.items map ((item, index) -> {value: item.id, displayValue: { label:item.name, properties: { helpText: "Account of $(item.email)" }}}))

type AccountDynamic = {
  accountId : Number
}

type OrderDynamic = {
  orderId : String,
  products : Array<Product>
}

type Product = {
  productId : String
}

var extendNestedFields : TypeValueDefinition =
    createExtendedObjectTypeValueDefinition("Order", OrderDynamic)
      withField createField("products",
          createArrayTypeValueDefinition(
                      createExtendedObjectTypeValueDefinition("Product", Product) withField  createField("description", createStringTypeValueDefinition())))

var orderType : TypeValueDefinition =
    createObjectTypeValueDefinition("Order")
      withField
        createField("orderId", createStringTypeValueDefinition(), true)
      withField
        createField("description",createStringTypeValueDefinition(), false)

var accountType : TypeValueDefinition =
    createExtendedObjectTypeValueDefinition("Account", AccountDynamic)
        withField createField("description", createStringTypeValueDefinition())

type MetadataProviderInputType = {objectType: String}
var metadataProvider: MetadataProviderExecutor<MetadataProviderInputType, {errorMessage: String}, HttpConnection> = (params, conn) ->
    if (params.objectType == "Order")
      success(orderType)
    else if (params.objectType == "Account")
      success(accountType)
    else if (params.objectType == "OrderExtended")
      success(extendNestedFields)
    else
      failure({errorMessage: "error"})


var usersValueProvider =
	defineValueProvider(getUsers.executor, (response: HttpResponse<{items: Array<{id: String, name: String, email: String}>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label: item.name, properties: {email: item.email}}}))

@TestConnector()
var connector = {
                    name: "DataWeaveExtension",
                    displayName: "Data Weave Extension",
                    connections: {  basicAuth: basicAuthConnectionProvider,
                                    apiKeyAuth: apiKeyAuthConnectionProvider,
                                    oauth2AuthCode: oauth2AuthCodeConnectionProvider,
                                    oauth2ClientCredentials:oauth2ClientCredentialsConnectionProvider,
                                    oauth2Implicit: oauth2ImplicitConnectionProvider,
                                    oauth2Password:oauth2PasswordConnectionProvider
                                },
                    testConnection: testConnection,
                    operations: {
                            updateAccountById: updateAccountById,
                            getMessages: getMessages,
                            getAccounts: getAccountsPaginated,
                            testFailures: testFailures
                    },
                    valueProviders: {
                       accountsValueProvider: accountsValueProvider,
                       accountsPaginatedValueProvider: accountsPaginatedValueProvider,
                       usersValueProvider: usersValueProvider
                    },
                    metadataProviders: {
                      metadataProvider: metadataProvider
                    },
                    triggers: {getUsersTrigger: getUsersTrigger, getUsersTriggerPaginated: getUsersTriggerPaginated,
                                getUsersTriggerPaginatedNoStartDate:getUsersTriggerPaginatedNoStartDate}
                }
