/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.provider;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.impl.ts.catalog.DefaultDWTypeCatalog;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.catalog.DWTypeCatalog;

class ObjectFieldSelectorTest {
    ObjectFieldSelectorTest() {
    }

    @Test
    void validatesNonEmptyValue() {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectFieldSelector.create((String)""));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Value cannot be empty"));
        exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> ObjectFieldSelector.create(null));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.equalTo((Object)"Value cannot be null"));
        Assertions.assertThrows(NullPointerException.class, () -> ObjectFieldSelector.create((boolean)true, null));
    }

    @Test
    void simpleField() {
        ObjectFieldSelector objectFieldSelector = ObjectFieldSelector.create((String)"property");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property"}));
        MatcherAssert.assertThat((Object)objectFieldSelector.isRelative(), (Matcher)Matchers.is((Object)true));
        objectFieldSelector = ObjectFieldSelector.create((String)"/property");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property"}));
        MatcherAssert.assertThat((Object)objectFieldSelector.isRelative(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void simpleQuotedField() {
        ObjectFieldSelector objectFieldSelector = ObjectFieldSelector.create((String)"'property'");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property"}));
    }

    @Test
    void simpleEscapedField() {
        ObjectFieldSelector objectFieldSelector = ObjectFieldSelector.create((String)"'prop \\.erty'");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"prop \\.erty"}));
    }

    @Test
    void nestedField() {
        ObjectFieldSelector objectFieldSelector = ObjectFieldSelector.create((String)"/property1/property2");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property1", "property2"}));
        MatcherAssert.assertThat((Object)objectFieldSelector.isRelative(), (Matcher)Matchers.is((Object)false));
        objectFieldSelector = ObjectFieldSelector.create((String)"property1/property2");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property1", "property2"}));
        MatcherAssert.assertThat((Object)objectFieldSelector.isRelative(), (Matcher)Matchers.is((Object)true));
        objectFieldSelector = ObjectFieldSelector.create((String)"property1/property2/");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property1", "property2"}));
        MatcherAssert.assertThat((Object)objectFieldSelector.isRelative(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void nestedQuotedField() {
        ObjectFieldSelector objectFieldSelector = ObjectFieldSelector.create((String)"/'property1'/'property2'");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property1", "property2"}));
    }

    @Test
    void mixedQuotedField() {
        ObjectFieldSelector objectFieldSelector = ObjectFieldSelector.create((String)"'property1'/'property2'/property3");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property1", "property2", "property3"}));
    }

    @Test
    void partiallyQuotedField() {
        ObjectFieldSelector objectFieldSelector = ObjectFieldSelector.create((String)"/p'roperty1'/'property2'");
        MatcherAssert.assertThat((Object)objectFieldSelector.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property1", "property2"}));
    }

    @Test
    void unclosedQuote() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectFieldSelector.create((String)"/'property"));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.is((Object)"Never closed quote in path: /'property"));
    }

    @Test
    void testEquals() {
        ObjectFieldSelector objectFieldSelector1 = ObjectFieldSelector.create((String)"propertyA");
        ObjectFieldSelector objectFieldSelector2 = ObjectFieldSelector.create((String)"propertyA");
        ObjectFieldSelector objectFieldSelector3 = ObjectFieldSelector.create((String)"propertyB");
        ObjectFieldSelector objectFieldSelector4 = ObjectFieldSelector.create((String)"/propertyA");
        MatcherAssert.assertThat((Object)objectFieldSelector1.equals(null), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)objectFieldSelector1.equals((Object)objectFieldSelector1), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)objectFieldSelector1.equals((Object)objectFieldSelector2), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)objectFieldSelector1.equals((Object)objectFieldSelector3), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)objectFieldSelector1.equals((Object)objectFieldSelector4), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)(objectFieldSelector1.hashCode() == objectFieldSelector1.hashCode() ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)(objectFieldSelector1.hashCode() == objectFieldSelector2.hashCode() ? 1 : 0), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)(objectFieldSelector1.hashCode() == objectFieldSelector3.hashCode() ? 1 : 0), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)(objectFieldSelector1.hashCode() == objectFieldSelector4.hashCode() ? 1 : 0), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void testToString() {
        MatcherAssert.assertThat((Object)ObjectFieldSelector.create((String)"a").toString(), (Matcher)Matchers.is((Object)"a"));
        MatcherAssert.assertThat((Object)ObjectFieldSelector.create((String)"a/b").toString(), (Matcher)Matchers.is((Object)"a/b"));
        MatcherAssert.assertThat((Object)ObjectFieldSelector.create((String)"/a/b").toString(), (Matcher)Matchers.is((Object)"/a/b"));
    }

    @Test
    void pathConstructor() {
        ObjectFieldSelector s = ObjectFieldSelector.create((boolean)false, List.of("property1", "property2"));
        MatcherAssert.assertThat((Object)s.getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property1", "property2"}));
        MatcherAssert.assertThat((Object)s.isRelative(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void resolve() {
        ObjectFieldSelector s1 = ObjectFieldSelector.create((boolean)false, List.of("property1", "property2"));
        ObjectFieldSelector rel = ObjectFieldSelector.create((boolean)true, List.of("property3", "property4"));
        MatcherAssert.assertThat((Object)s1.resolve(rel).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property1", "property2", "property3", "property4"}));
        ObjectFieldSelector abs = ObjectFieldSelector.create((boolean)false, List.of("property3", "property4"));
        MatcherAssert.assertThat((Object)s1.resolve(abs).getPath(), (Matcher)Matchers.arrayContaining((Object[])new String[]{"property3", "property4"}));
    }

    @Test
    void evaluateOn() {
        DWTypeCatalog catalog = DefaultDWTypeCatalog.loader().fromCatalog("%dw 2.9\n\ntype WithStreet = {\n  street: String,\n  number: Number\n}\n\ntype WithNumber = {\n  street: String,\n  number: Number\n}\n\ntype Address = WithStreet & WithNumber\n\ntype WithName = {\n  name: String\n}\n\ntype WithAddress = {\n  address: Address\n}\n\ntype Contact = WithName & WithAddress\n");
        DWType type = (DWType)catalog.getType("Contact").orElseThrow();
        MatcherAssert.assertThat((Object)TypeUtils.resolveReferenceType((DWType)((DWType)ObjectFieldSelector.create((String)"/address").evaluateOn(type).orElseThrow())), (Matcher)Matchers.instanceOf(IntersectionType.class));
        MatcherAssert.assertThat((Object)((DWType)ObjectFieldSelector.create((String)"/address/street").evaluateOn(type).orElseThrow()), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)((DWType)ObjectFieldSelector.create((String)"/address/number").evaluateOn(type).orElseThrow()), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)ObjectFieldSelector.create((String)"/address/street/missing").evaluateOn(type), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)ObjectFieldSelector.create((String)"/missing").evaluateOn(type), (Matcher)Matchers.is(Optional.empty()));
    }
}

