%dw 2.8

import OperationElement from com::mulesoft::connectivity::Metadata

import Result, failure, success from com::mulesoft::connectivity::Model

import HttpConnection from com::mulesoft::connectivity::transport::Http

import serializeCookies, serializeHeaders, withSerializationConfig from com::mulesoft::connectivity::transport::Serialization

import getBannerType, setBannerType from ccm::jira::OperationTypes

@OperationElement()
var getBanner = {
  name: "getBanner",
  displayName: "getBanner",
  executor: (parameter: getBannerType.request, connection: HttpConnection): Result<getBannerType.response, getBannerType.errorResponse> -> do {
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "GET",
        path: "/rest/api/2/announcementBanner",
        queryParams: query,
        headers: headers,
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response200 if response200.status == 200 -> success(response200 as getBannerType."200")
        case response401 if response401.status == 401 -> failure(response401 as getBannerType."401", {
          kind: "status-401",
          categories: ["CLIENT_ERROR"]
        }, "Returned if the authentication credentials are incorrect or missing.")
        case response403 if response403.status == 403 -> failure(response403 as getBannerType."403", {
          kind: "status-403",
          categories: ["CLIENT_ERROR"]
        }, "Returned if the user does not have the necessary permission.")
        else responsedefault-> failure(responsedefault, {
          kind: "status-unexpected",
          categories: []
        }, "Unexpected status code")
      }
    }
}

@OperationElement()
var setBanner = {
  name: "setBanner",
  displayName: "setBanner",
  executor: (parameter: setBannerType.request, connection: HttpConnection): Result<setBannerType.response, setBannerType.errorResponse> -> do {
      var query = parameter.query default {} withSerializationConfig {}
      var headers = serializeHeaders(parameter.headers default {}, {})
      var cookie = serializeCookies(parameter.cookie default {}, {})
      var response = connection({
        method: "PUT",
        path: "/rest/api/2/announcementBanner",
        queryParams: query,
        headers: headers,
        config: {
          contentType: "application/json"
        },
        cookie: cookie,
        (body: parameter.body) if (parameter.body?)
      })
      ---
      response match {
        case response204 if response204.status == 204 -> success(response204 as setBannerType."204")
        case response400 if response400.status == 400 -> failure(response400 as setBannerType."400", {
          kind: "status-400",
          categories: ["CLIENT_ERROR"]
        }, "Returned if an invalid parameter is passed.")
        case response401 if response401.status == 401 -> failure(response401 as setBannerType."401", {
          kind: "status-401",
          categories: ["CLIENT_ERROR"]
        }, "Returned if the authentication credentials are incorrect or missing.")
        case response403 if response403.status == 403 -> failure(response403 as setBannerType."403", {
          kind: "status-403",
          categories: ["CLIENT_ERROR"]
        }, "Returned if the user does not have the necessary permission.")
        else responsedefault-> failure(responsedefault, {
          kind: "status-unexpected",
          categories: []
        }, "Unexpected status code")
      }
    }
}
