/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.loader.ContextVariablesResolver;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.ErrorModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;

public abstract class ExecutableComponentModel<T extends ExecutableComponentModel<?>>
extends BaseExecutableComponentModel<T> {
    protected final String displayName;
    protected final TypeModel outputType;
    protected final TypeModel errorOutputType;
    protected final List<ErrorModel> errorModels;
    protected final TypeModel inputType;
    protected final Map<ObjectFieldSelector, ProviderReferences> inputResolvedProviders;
    protected final Map<ObjectFieldSelector, ProviderReferences> outputResolvedProviders;

    protected ExecutableComponentModel(@Nullable String modelReference, String name, String displayName, TypeModel outputType, TypeModel errorOutputType, TypeModel inputType, boolean isPaginated, @Nullable Map<ObjectFieldSelector, ProviderReferences> inputResolvedProviders, @Nullable Map<ObjectFieldSelector, ProviderReferences> outputResolvedProviders, @Nullable List<ErrorModel> errorModels, NavigableMap<Integer, T> extraVersions, boolean base) {
        super(modelReference, name, extraVersions, base, isPaginated);
        this.displayName = displayName;
        this.outputType = outputType;
        this.errorOutputType = errorOutputType;
        this.inputType = inputType;
        this.inputResolvedProviders = Objects.requireNonNullElse(inputResolvedProviders, Map.of());
        this.outputResolvedProviders = Objects.requireNonNullElse(outputResolvedProviders, Map.of());
        this.errorModels = Objects.requireNonNullElse(errorModels, List.of());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TypeModel getInputType() {
        return this.inputType;
    }

    public TypeModel getOutputType() {
        return this.outputType;
    }

    public TypeModel getErrorOutputType() {
        return this.errorOutputType;
    }

    public List<ErrorModel> getErrorDefinitions() {
        return this.errorModels;
    }

    public Map<ObjectFieldSelector, ProviderReferences> getInputResolvedProviders() {
        return this.inputResolvedProviders;
    }

    public Map<ObjectFieldSelector, ProviderReferences> getOutputResolvedProviders() {
        return this.outputResolvedProviders;
    }

    @Deprecated
    public Optional<ProviderReferences> getInputProviderReferencesFor(ObjectFieldSelector fieldSelector, @Nullable DWType actualMetadata) {
        if (actualMetadata == null || actualMetadata.equals(this.getInputType().getDataType())) {
            return Optional.ofNullable(this.inputResolvedProviders.get(fieldSelector));
        }
        return Optional.ofNullable(ContextVariablesResolver.resolveContextVariablesOnInput(actualMetadata).get(fieldSelector));
    }

    private Optional<ProviderReference> getValueProviderReferenceFor(ObjectFieldSelector fieldSelector, @Nullable DWType actualMetadata) {
        return this.getInputProviderReferencesFor(fieldSelector, actualMetadata).map(p -> p.valueProviderReference);
    }

    private Optional<ProviderReference> getInputMetadataProviderReferenceFor(ObjectFieldSelector fieldSelector, @Nullable DWType actualMetadata) {
        return this.getInputProviderReferencesFor(fieldSelector, actualMetadata).map(p -> p.metadataProviderReference);
    }

    @Deprecated
    public Optional<ProviderReference> getValueProviderReferenceFor(String fieldSelector, @Nullable DWType actualMetadata) {
        return this.getValueProviderReferenceFor(ObjectFieldSelector.create(fieldSelector), actualMetadata);
    }

    public Optional<ProviderReference> getValueProviderReferenceFor(ObjectFieldSelector fieldSelector) {
        return this.getValueProviderReferenceFor(fieldSelector, null);
    }

    public Optional<ProviderReference> getInputMetadataProviderReferenceFor(ObjectFieldSelector fieldSelector) {
        return this.getInputMetadataProviderReferenceFor(fieldSelector, null);
    }

    public Optional<ProviderReference> getInputMetadataProviderReferenceFor(String fieldSelector) {
        return this.getInputMetadataProviderReferenceFor(ObjectFieldSelector.create(fieldSelector));
    }

    public Optional<ProviderReference> getValueProviderReferenceFor(String fieldSelector) {
        return this.getValueProviderReferenceFor(ObjectFieldSelector.create(fieldSelector));
    }

    @Deprecated
    public Optional<ProviderReferences> getOutputProviderReferencesFor(ObjectFieldSelector fieldSelector, @Nullable DWType actualMetadata) {
        if (actualMetadata == null || actualMetadata.equals(this.getOutputType().getDataType())) {
            return Optional.ofNullable(this.outputResolvedProviders.get(fieldSelector));
        }
        return Optional.ofNullable(ContextVariablesResolver.resolveContextVariablesOnOutput(actualMetadata, this.getInputType().getDataType()).get(fieldSelector));
    }

    private Optional<ProviderReference> getOutputMetadataProviderReferenceFor(ObjectFieldSelector fieldSelector, @Nullable DWType actualMetadata) {
        return this.getOutputProviderReferencesFor(fieldSelector, actualMetadata).map(p -> p.metadataProviderReference);
    }

    public Optional<ProviderReference> getOutputMetadataProviderReferenceFor(String fieldSelector) {
        return this.getOutputMetadataProviderReferenceFor(ObjectFieldSelector.create(fieldSelector));
    }

    public Optional<ProviderReference> getOutputMetadataProviderReferenceFor(ObjectFieldSelector fieldSelector) {
        return this.getOutputMetadataProviderReferenceFor(fieldSelector, null);
    }

    public static class ProviderReferences {
        private final @Nullable ProviderReference valueProviderReference;
        private final @Nullable ProviderReference metadataProviderReference;

        public ProviderReferences(@Nullable ProviderReference valueProviderReference, @Nullable ProviderReference metadataProviderReference) {
            this.valueProviderReference = valueProviderReference;
            this.metadataProviderReference = metadataProviderReference;
        }

        public @Nullable ProviderReference getValueProviderReference() {
            return this.valueProviderReference;
        }

        public @Nullable ProviderReference getMetadataProviderReference() {
            return this.metadataProviderReference;
        }

        public String toString() {
            return "Providers{valueProviderReference=" + String.valueOf(this.valueProviderReference) + "metadataProviderReference=" + String.valueOf(this.metadataProviderReference) + "}";
        }
    }

    public static abstract class ExecutableComponentBuilder<M extends ExecutableComponentModel<?>, T extends ExecutableComponentBuilder<M, T>>
    extends Model.Builder<M, T> {
        protected @Nullable String name;
        protected @Nullable String displayName;
        protected @Nullable TypeModel outputType;
        protected @Nullable TypeModel errorOutputType;
        protected @Nullable TypeModel inputType;
        protected boolean isPaginated;
        protected @Nullable Map<ObjectFieldSelector, ProviderReferences> resolvedInputProviders;
        protected @Nullable Map<ObjectFieldSelector, ProviderReferences> resolvedOutputProviders;
        protected @Nullable List<ErrorModel> errorModels;
        protected @Nullable NavigableMap<Integer, M> versions;
        protected boolean base = true;

        public T withName(String name) {
            this.name = name;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T withDisplayName(String displayName) {
            this.displayName = displayName;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T withInputType(TypeModel inputType) {
            this.inputType = inputType;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T withOutputType(TypeModel outputType) {
            this.outputType = outputType;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T withErrorOutputType(TypeModel errorOutputType) {
            this.errorOutputType = errorOutputType;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T isPaginated(boolean isPaginated) {
            this.isPaginated = isPaginated;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T resolvedInputProviders(Map<ObjectFieldSelector, ProviderReferences> resolvedProviders) {
            this.resolvedInputProviders = resolvedProviders;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T resolvedOutputProviders(Map<ObjectFieldSelector, ProviderReferences> resolvedProviders) {
            this.resolvedOutputProviders = resolvedProviders;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T withErrorModels(List<ErrorModel> errorModels) {
            this.errorModels = errorModels;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T withVersions(NavigableMap<Integer, M> versions) {
            this.versions = versions;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }

        public T withIsBase(boolean base) {
            this.base = base;
            return (T)((ExecutableComponentBuilder)this.getThis());
        }
    }
}

