/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;

public class DynamicMetadataOutputTest
extends AbstractConnectivityModelTest {
    protected final ModelInterpreter modelInterpreter = new ModelInterpreter(dataWeaveScriptingEngine, new ModelInterpreterConfig.Builder().build());

    @Test
    void outputObject() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::OutputMetadata");
        OperationModel operation = connectorModel.getOperation("outputObjectOperation");
        ProviderReference reference = (ProviderReference)MetadataUtils.getMetadataProvider((DWType)operation.getOutputType().getDataType()).orElseThrow();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"outputObjectProvider"));
        ObjectType outputType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)outputType, (String)"id").getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
    }

    @Test
    void dynamicOutputNestedField() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::OutputMetadata");
        OperationModel operation = connectorModel.getOperation("nestedDynamicOutputFieldOperation");
        ProviderReference reference = (ProviderReference)operation.getOutputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/record/dynamicField")).get();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"nestedDynamicOutputFieldProvider"));
        ObjectType newFieldType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newFieldType, (String)"id").getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
    }

    @Test
    void outputObjectWithCustomFields() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::OutputMetadata");
        OperationModel operation = connectorModel.getOperation("outputObjectWithCustomFieldsOperation");
        ProviderReference reference = (ProviderReference)MetadataUtils.getMetadataProvider((DWType)operation.getOutputType().getDataType()).orElseThrow();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"outputObjectWithCustomFieldsProvider"));
        ObjectType newOutputType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newOutputType, (String)"id").getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newOutputType, (String)"field0").getValue(), (Matcher)Matchers.instanceOf(StringType.class));
    }

    @Test
    void outputObjectDynamicFieldWithCustomFields() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::OutputMetadata");
        OperationModel operation = connectorModel.getOperation("nestedCustomFieldsOutputOperation");
        ProviderReference reference = (ProviderReference)operation.getOutputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/record/dynamicField")).orElseThrow();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"nestedCustomFieldsOutputProvider"));
        ObjectType newOutputFieldType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newOutputFieldType, (String)"id").getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newOutputFieldType, (String)"field1").getValue(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)((ExecutableComponentModel.ProviderReferences)operation.getOutputResolvedProviders().get(ObjectFieldSelector.create((String)"/record/dynamicField"))).getMetadataProviderReference(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    void paginatedCustomFields() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::OutputMetadata");
        OperationModel operation = connectorModel.getOperation("paginatedCustomFields");
        ArrayType outputType = (ArrayType)operation.getOutputType().getDataType();
        DWType itemType = outputType.arrayOf();
        ProviderReference reference = (ProviderReference)MetadataUtils.getMetadataProvider((DWType)itemType).orElseThrow();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"paginationCustomFieldsProvider"));
        ObjectType newOutputFieldType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newOutputFieldType, (String)"field3").getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newOutputFieldType, (String)"id").getValue(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newOutputFieldType, (String)"name").getValue(), (Matcher)Matchers.instanceOf(StringType.class));
    }

    @Test
    void paginatedOutputObject() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::OutputMetadata");
        OperationModel operation = connectorModel.getOperation("paginatedOutputObject");
        ArrayType outputType = (ArrayType)operation.getOutputType().getDataType();
        DWType itemType = outputType.arrayOf();
        ProviderReference reference = (ProviderReference)MetadataUtils.getMetadataProvider((DWType)itemType).orElseThrow();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"paginationOutputObjectProvider"));
        ObjectType newOutputFieldType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        MatcherAssert.assertThat((Object)DWTypeUtils.requireFieldByName((ObjectType)newOutputFieldType, (String)"field4").getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
    }

    private DWType executeMetadataProvider(TestConnectorModel connectorModel, String providerName) {
        MetadataProviderModel metadataProvider = connectorModel.getMetadataProvider(providerName);
        return (DWType)this.modelInterpreter.executeMetadataProvider(connectorModel.getConnectionProviders().get(0), this.createConnectionInfo(), metadataProvider, Map.of()).getValue();
    }

    private Map<String, Object> createConnectionInfo() {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("baseUri", "http://api.acme.com/v1");
        connectionInfo.put("user", "jdoe");
        connectionInfo.put("pass", "secret");
        return connectionInfo;
    }
}

