/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class MetadataInjectionModelLargeSetLoaderTest
extends AbstractConnectivityModelTest {
    MetadataInjectionModelLargeSetLoaderTest() {
    }

    @Test
    void loadsFieldMetadata() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataInjectionLargeSet::Connector");
        ConnectionProviderModel connection = connectorModel.getConnectionProviders().get(0);
        ObjectType connectionInputType = (ObjectType)TypeUtils.resolveReferenceType((DWType)connection.getInputType().getDataType());
        String connectionLabel = MetadataUtils.requireLabel((DWType)connection.getInputType().getDataType());
        Assertions.assertEquals((Object)"Salesforce basic connection", (Object)connectionLabel);
        String orgIdLabel = MetadataUtils.requireLabel((DWType)DWTypeUtils.requireFieldByName((ObjectType)connectionInputType, (String)"orgId").getValue());
        Assertions.assertEquals((Object)"orgId basic connection", (Object)orgIdLabel);
        String tokenLabel = MetadataUtils.requireLabel((DWType)DWTypeUtils.requireFieldByName((ObjectType)connectionInputType, (String)"token").getValue());
        Assertions.assertEquals((Object)"token basic connection", (Object)tokenLabel);
        OperationModel operation = connectorModel.getOperations().get(1);
        MatcherAssert.assertThat((Object)operation.getName(), (Matcher)Matchers.equalTo((Object)"createAccount"));
        ObjectType inputType = (ObjectType)TypeUtils.resolveReferenceType((DWType)operation.getInputType().getDataType());
        MatcherAssert.assertThat((Object)inputType, (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        ObjectType body = (ObjectType)TypeUtils.resolveReferenceType((DWType)DWTypeUtils.requireFieldByName((ObjectType)inputType, (String)"body").getValue());
        Assertions.assertTrue((boolean)DWTypeUtils.getFieldByName((ObjectType)body, (String)"billingGeocodeAccuracy").isPresent());
        DWType billingGeocodeAccuracyFieldValue = DWTypeUtils.requireFieldByName((ObjectType)body, (String)"billingGeocodeAccuracy").getValue();
        Assertions.assertEquals((int)billingGeocodeAccuracyFieldValue.getTypeMetadata().length, (int)2);
        ProviderReference billingGeocodeAccuracyValueProvider = MetadataUtils.requireValueProvider((DWType)billingGeocodeAccuracyFieldValue);
        Assertions.assertEquals((Object)billingGeocodeAccuracyValueProvider.getName(), (Object)"accountBillingGeocodeAccuracyValueProvider");
        MatcherAssert.assertThat((Object)billingGeocodeAccuracyValueProvider.getArguments(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        String billingGeocodeAccuracyFieldValueLabel = MetadataUtils.requireLabel((DWType)billingGeocodeAccuracyFieldValue);
        MatcherAssert.assertThat((Object)billingGeocodeAccuracyFieldValueLabel, (Matcher)Matchers.equalTo((Object)"Billing Geocode Accuracy"));
    }
}

