%dw 2.7
import TestConnector from Metadata
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::decorator::ValueProvider
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::transport::Http
import * from test003::Module

@OperationElement()
var getUserByIdCustomOperation =
(getUserByIdEndpoint mapInputOperation
    (param: {
            userId: GetUserByIdEndpointRequest.uri.userId,
            metadata: GetUserByIdEndpointRequest.query.metadata,
            customHeader: GetUserByIdEndpointRequest.headers.customHeader} )
     -> {uri: {userId: param.userId}, query: {metadata: param.metadata}, headers: {customHeader: param.customHeader},
      cookie: {cookie1:"value1",cookie2:"value2"}})
     update {
         case name at .name -> "getUserByIdCustom"
         case displayName at .displayName -> "Get user by id custom"
     }
var usersValueProvider =
 defineValueProvider(getUsers.executor, (response: HttpResponse<GetUsersEndpointResponse>) ->  response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name}}))

@TestConnector()
var connector = {
                    name: "DataWeaveExtension",
                    displayName: "Data Weave Extension",
                    connections: {basicAuth: connectionProvider},
                    operations: {
                            getUserByIdEndpoint: getUserByIdEndpoint,
                            getUsers: getUsersPaginatedCustom,
                            getUserByIdCustom: getUserByIdCustomOperation,
                            getUsers2: getUsersPaginatedWithDifferentSecondOperation,
                    },
                    testConnection: testConnection,
                    valueProviders: {
                       usersValueProvider: usersValueProvider
                    },
                    metadataProviders: {}
                }
