%dw 2.7

import TestConnector from Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http
import * from com::mulesoft::connectivity::decorator::ValueProvider

type Country = {
   id: String,
   name: String,
}

var getCountries : Operation<{}, HttpResponse<{items: Array<Country>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getCountries",
    displayName: "Get Countries",
    executor: (parameter, connection) -> success({
          contentType: "application/json",
          status: 200,
          headers: {},
          cookies: {},
          body: {
            items: [
              {
                id: "AR",
                name: "Argentina",
              },
              {
                id: "BR",
                name: "Brazil",
              },
              {
                id: "UY",
                name: "Uruguay",
              }
            ]
          }
    })
}

var countriesValueProvider =
    defineValueProvider(getCountries.executor, (response: HttpResponse<{items: Array<Country>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name}}))

type City = {
   id: String,
   name: String
}

var getCities : Operation<{country: String}, HttpResponse<{items: Array<City>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "getProjectTicketTypes",
    displayName: "Get Project Tocket Types",
    executor: (parameter, connection) -> parameter.country match {
        case "AR" -> do {
          success({
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {},
                body: {
                  items: [
                    {
                      id: "1",
                      name: "Buenos Aires",
                    },
                    {
                      id: "2",
                      name: "Tandil",
                    },
                    {
                      id: "3",
                      name: "Bariloche",
                    },
                  ]
                }
          })
          }
        case "BR" -> do {
           success({
                 contentType: "application/json",
                 status: 200,
                 headers: {},
                 cookies: {},
                 body: {
                   items: [
                     {
                       id: "1",
                       name: "Rio do Janeiro",
                     },
                     {
                       id: "2",
                       name: "São Paulo",
                     },
                   ]
                 }
           })
           }
           else -> do {
                   success({
                         contentType: "application/json",
                         status: 200,
                         headers: {},
                         cookies: {},
                         body: {
                           items: []
                         }
                   })
            }
    }
}

var citiesValueProvider =
    defineValueProvider(getCities.executor, (response: HttpResponse<{items: Array<City>}>) -> response.body.items map ((item, index) -> {value: item.id, displayValue: { label:item.name}}))

type Address = @With(value = { country: "country" }) {
    street: String,
    country: @ValuesFrom(value = { name: "countriesValueProvider", arguments: { means: "#means" } }) String,
    countryWithAbsoluteReference: @ValuesFrom(value = { name: "countriesValueProvider", arguments: {means: "/means" } }) String,
    city: @ValuesFrom(value = { name: "citiesValueProvider", arguments: { country: "#country" } }) String,
    cityWithRelativeReference: @ValuesFrom(value = { name: "citiesValueProvider", arguments: { country: "country" } }) String
}

type CalculateRouteType = @With(value = { means: "means" }) {
    means: String,
    origin: Address,
    destination: Address
}

type Route = {
    distance: Number
}

// Connection

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var simpleConnection = defineBasicHttpConnectionProvider<BasicAuthSchema>(
    (parameter) -> parameter,
    (parameter) -> {baseUri: "http://localhost"}
)

@ConnectionElement()
var bearerConnection = defineBearerHttpConnectionProvider<BearerAuthSchema>(
    (parameter) -> parameter,
    (parameter) -> {baseUri: "http://localhost"}
)

@ConnectionElement()
var apiKeyConnection = defineApiKeyHttpConnectionProvider<ApiKeyAuthSchema>(
    (parameter) -> parameter,
    (parameter) -> {baseUri: "http://localhost"},
    {in: 'header', name: "X-API-KEY"}
)

@ConnectionElement()
var oauth2AuthCodeConnectionProvider = defineOAuth2Connection<OAuth2AuthSchema>(
    (parameter) -> parameter,
    (parameter) -> {baseUri: "http://localhost"},
    {
        grantType: 'authorizationCode',
        authorizationUrl: "http://localhost/authorize",
        tokenUrl: "http://localhost/token",
        refreshUrl: "http://localhost/token",
        scopes: ["test"]
    }
)

@ConnectionElement()
var connection = defineBasicHttpConnectionProvider<@Label(value = "basic connection") {
    baseUri: @Label(value = "The base uri that will be used for all HTTP requests") String,
    user: @Label(value = "The username used to authenticate the requests") String,
    pass: @Label(value = "The password used to authenticate the requests") @SemanticTerms(value = ["password"]) String
}>(
    (parameter) -> {username: parameter.user, password: parameter.pass},
    (parameter) -> {baseUri: parameter.baseUri}
)

var calculateRoute : Operation<CalculateRouteType, HttpResponse<Route>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "calculateRoute",
    displayName: "Calculate route",
    executor: (parameter, connection): Result<HttpResponse<Route>, ResultFailure<HttpResponse, Error>> ->
        success({
            contentType: "application/json",
            status: 200,
            headers: connection.headers default {} ++ { baseUri: connection.baseUri default "" },
            cookies: {},
            body: {id: "1"} ++ parameter
    }) as ResultSuccess<HttpResponse<Route>>
}

@TestConnector()
var connector = {
    name: "Routing",
    displayName: "Routing",
    connections: {basicAuth: connection},
    operations: {
       calculateRoute: calculateRoute
    },
    testConnection: testConnection,
    metadataProviders: {},
    valueProviders: {
        countriesValueProvider: countriesValueProvider,
        citiesValueProvider: citiesValueProvider,
    }
}
