/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.trigger;

import com.mulesoft.connectivity.linkweave.api.model.trigger.EagerTriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextPoll;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerEagerPage;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerItem;
import com.mulesoft.connectivity.linkweave.test.OptionalMatchers;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

class TriggerEagerPageTest {
    TriggerEagerPageTest() {
    }

    @Test
    public void basic() {
        EagerTriggerItem triggerItemOne = new EagerTriggerItem((Object)"One", (Object)1, "1");
        EagerTriggerItem triggerItemTwo = new EagerTriggerItem((Object)"Two", (Object)2, "2");
        String np = "NextPageData";
        NextPoll nextPoll = new NextPoll(null, null);
        TriggerEagerPage page1 = new TriggerEagerPage(List.of(triggerItemOne, triggerItemTwo), (Serializable)((Object)np), nextPoll);
        MatcherAssert.assertThat(page1.getItems().stream().map(EagerTriggerItem::getValue).toList(), (Matcher)Matchers.hasItems((Object[])new Object[]{"One", "Two"}));
        MatcherAssert.assertThat((Object)page1.getNextPage(), OptionalMatchers.isPresentAnd(Matchers.is((Object)np)));
        MatcherAssert.assertThat((Object)page1.getNextPoll(), (Matcher)Matchers.equalTo((Object)nextPoll));
        TriggerEagerPage page2 = new TriggerEagerPage(List.of(triggerItemOne, triggerItemTwo), null, new NextPoll((Serializable)((Object)"111"), (Serializable)((Object)"222")));
        MatcherAssert.assertThat((Object)page2.getNextPage(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)page1.toString(), (Matcher)Matchers.is((Object)"{items=[Item{value=One, watermark=1, identity=1}, Item{value=Two, watermark=2, identity=2}], nextPage=NextPageData, nextPoll= { greatestWatermark=null, latestWatermark=null}}"));
        MatcherAssert.assertThat((Object)page2.toString(), (Matcher)Matchers.is((Object)"{items=[Item{value=One, watermark=1, identity=1}, Item{value=Two, watermark=2, identity=2}], nextPoll= { greatestWatermark=111, latestWatermark=222}}"));
        MatcherAssert.assertThat((Object)page1.equals(page1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)page1.equals(page2), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)(page1.hashCode() != page2.hashCode() ? 1 : 0), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void builderFromPaginatedDataTriggers() {
        String np = "NextPageData";
        HashMap<String, Integer> nPoll = new HashMap<String, Integer>();
        nPoll.put("greatestWatermark", 111);
        Function fn = TriggerEagerPage.triggerPageFactory().getBuilderFunction(true, data -> new EagerTriggerItem((Object)("x" + String.valueOf(data)), (Object)1, "1"));
        TriggerEagerPage page = (TriggerEagerPage)fn.apply(Map.of("items", List.of("One", "Two"), "nextPage", np, "value", "original-value", "nextPoll", nPoll));
        MatcherAssert.assertThat(page.getItems().stream().map(TriggerItem::getValue).toList(), (Matcher)Matchers.hasItems((Object[])new Object[]{"xOne", "xTwo"}));
        Serializable greatestWatermarkObject = page.getNextPoll().getGreatestWatermark();
        Serializable latestWatermarkObject = page.getNextPoll().getLatestWatermark();
        Serializable nextPageObject = (Serializable)page.getNextPage().orElseThrow();
        MatcherAssert.assertThat((Object)nextPageObject, (Matcher)Matchers.is((Object)np));
        MatcherAssert.assertThat((Object)greatestWatermarkObject, (Matcher)Matchers.is((Object)111));
        MatcherAssert.assertThat((Object)latestWatermarkObject, (Matcher)Matchers.nullValue());
    }
}

