%dw 2.7

import TestConnector from  Metadata

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::metadata::Builder
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http

// root level dynamic field
var record1 : TypeValueDefinition =
  createObjectTypeValueDefinition("Record")
  withField createField("id", createNumberTypeValueDefinition())

var rootLevelDynamicFieldProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record1)

type RootLevelDynamicFieldParameters = {
    record: @MetadataProvider(value = { name: "rootLevelDynamicFieldProvider" }) Object
}

var rootLevelDynamicFieldOperation : Operation<RootLevelDynamicFieldParameters, {}, ResultFailure<{}, Error>, HttpConnection> = {
    name: "rootLevelDynamicFieldOperation",
    displayName: "rootLevelDynamicFieldOperation",
    executor: (parameter, connection) -> success({id: 1, value: 2})
}

// dynamic nested field
var record2 : TypeValueDefinition =
  createObjectTypeValueDefinition("Record")
  withField createField("id", createNumberTypeValueDefinition())

var nestedDynamicFieldProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record2)

type NestedDynamicFieldParameters = {
    record: {
        id: Number,
        dynamicField: @MetadataProvider(value = { name: "nestedDynamicFieldProvider" }) Object
    }
}

var nestedDynamicFieldOperation : Operation<NestedDynamicFieldParameters, {}, ResultFailure<{}, Error>, HttpConnection> = {
    name: "nestedDynamicFieldOperation",
    displayName: "nestedDynamicFieldOperation",
    executor: (parameter, connection) -> success({id: 1, value: 2})
}

// adding custom fields to existing object
type ExistingObject0 = {
    field0 : String
}

var record3 : TypeValueDefinition =
  createExtendedObjectTypeValueDefinition("ExistingObject0", ExistingObject0)
  withField createField("id", createNumberTypeValueDefinition())

var rootLevelCustomFieldsProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record3)

type RootLevelCustomFieldsParameters = {
    record: @MetadataProvider(value = { name: "rootLevelCustomFieldsProvider" }) ExistingObject0
}

var rootLevelCustomFieldsOperation : Operation<RootLevelCustomFieldsParameters, {}, ResultFailure<{}, Error>, HttpConnection> = {
    name: "rootLevelCustomFieldsOperation",
    displayName: "rootLevelCustomFieldsOperation",
    executor: (parameter, connection) -> success({id: 1, value: 2})
}

// adding custom fields to existing object nested
type ExistingObject1 = {
    field1 : String
}

var record4 : TypeValueDefinition =
  createExtendedObjectTypeValueDefinition("ExistingObject1", ExistingObject1)
  withField createField("id", createNumberTypeValueDefinition())

var nestedCustomFieldsProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record4)

type NestedCustomFieldsParameters = {
    record: {
        id: Number,
        dynamicField: @MetadataProvider(value = { name : "nestedCustomFieldsProvider" }) ExistingObject1
    }
}

var nestedCustomFieldsOperation : Operation<NestedCustomFieldsParameters, {}, ResultFailure<{}, Error>, HttpConnection> = {
    name: "nestedCustomFieldsOperation",
    displayName: "nestedCustomFieldsOperation",
    executor: (parameter, connection) -> success({id: 1, value: 2})
}

@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var basicAuthConnection = defineBasicHttpConnectionProvider<BasicAuthSchema>(
                              (parameter) -> parameter,
                              (parameter) -> {baseUri: "http://localhost"
                              }
)

@TestConnector()
var connector = {
    name: "DataWeaveExtension",
    displayName: "Data Weave Extension",
    connections: {basicAuth: basicAuthConnection},
    testConnection: testConnection,
    operations: {
       rootLevelDynamicFieldOperation: rootLevelDynamicFieldOperation,
       nestedDynamicFieldOperation: nestedDynamicFieldOperation,
       rootLevelCustomFieldsOperation: rootLevelCustomFieldsOperation,
       nestedCustomFieldsOperation: nestedCustomFieldsOperation
    },
    valueProviders: {
    },
    metadataProviders: {
      rootLevelDynamicFieldProvider: rootLevelDynamicFieldProvider,
      nestedDynamicFieldProvider: nestedDynamicFieldProvider,
      rootLevelCustomFieldsProvider: rootLevelCustomFieldsProvider,
      nestedCustomFieldsProvider: nestedCustomFieldsProvider
    }
}
