%dw 2.7

import TestConnector from Metadata
import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Annotations
import * from com::mulesoft::connectivity::decorator::Operation
import * from com::mulesoft::connectivity::metadata::Builder
import * from com::mulesoft::connectivity::Metadata
import * from com::mulesoft::connectivity::transport::Http

// output Object
var record1 : TypeValueDefinition =
  createObjectTypeValueDefinition("Record")
  withField createField("id", createNumberTypeValueDefinition())

var outputObjectProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record1)

type Record1 = @MetadataProvider(value = { name: "outputObjectProvider"}) Object

var outputObjectOperation : Operation<{}, Record1, ResultFailure<{}, Error>, HttpConnection> = {
    name: "outputObjectOperation",
    displayName: "outputObjectOperation",
    executor: (parameter, connection) -> success({id: 1, value: 2})
}

// dynamic nested field
var record2 : TypeValueDefinition =
  createObjectTypeValueDefinition("Record")
  withField createField("id", createNumberTypeValueDefinition())

var nestedDynamicOutputFieldProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record2)

type NestedDynamicFieldOutput = {
    record : {
        id: Number,
        dynamicField : @MetadataProvider(value = { name : "nestedDynamicOutputFieldProvider" }) Object
    }
}

var nestedDynamicOutputFieldOperation : Operation<{}, NestedDynamicFieldOutput, ResultFailure<{}, Error>, HttpConnection> = {
    name: "nestedDynamicOutputFieldOperation",
    displayName: "nestedDynamicOutputFieldOperation",
    executor: (parameter, connection) -> success({record : {id: 1, dynamicField: {}}})
}

// adding custom fields to existing object
type ExistingObject0 = {
    field0 : String
}

var record3 : TypeValueDefinition =
  createExtendedObjectTypeValueDefinition("ExistingObject0", ExistingObject0)
  withField createField("id", createNumberTypeValueDefinition())

var outputObjectWithCustomFieldsProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record3)

type OutputObjectWithCustomFields = @MetadataProvider(value = { name: "outputObjectWithCustomFieldsProvider" }) ExistingObject0

var outputObjectWithCustomFieldsOperation : Operation<{}, OutputObjectWithCustomFields, ResultFailure<{}, Error>, HttpConnection> = {
    name: "outputObjectWithCustomFieldsOperation",
    displayName: "outputObjectWithCustomFieldsOperation",
    executor: (parameter, connection) -> success({field0: "1"})
}

// output nested field with custom fields
type ExistingObject1 = {
    field1 : String
}

var record4 : TypeValueDefinition =
  createExtendedObjectTypeValueDefinition("ExistingObject1", ExistingObject1)
  withField createField("id", createNumberTypeValueDefinition())

var nestedCustomFieldsOutputProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record4)

type NestedCustomFieldsOutput = {
    record: {
        id: Number,
        dynamicField: @MetadataProvider(value = { name: "nestedCustomFieldsOutputProvider" }) ExistingObject1
    }
}

var nestedCustomFieldsOutputOperation : Operation<{}, NestedCustomFieldsOutput, ResultFailure<{}, Error>, HttpConnection> = {
    name: "nestedCustomFieldsOutputOperation",
    displayName: "nestedCustomFieldsOutputOperation",
    executor: (parameter, connection) -> success({record :{id: 1, dynamicField: { field1: ""}}})
}

// paginated output with custom fields
type Input0 = {
  page: Number,
  limit: Number
}
type OutputRecord0 = {
  id: String,
  name: String
}
var record5 : TypeValueDefinition =
  createExtendedObjectTypeValueDefinition("OutputRecord0", OutputRecord0)
  withField createField("field3", createNumberTypeValueDefinition())

var paginationCustomFieldsProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record5)

var getPageNumber : Operation<Input0, HttpResponse<{items: Array<OutputRecord0>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "paginatedCustomFields",
    displayName: "paginatedCustomFields",
    executor: (parameter, connection) -> do {
        var response = connection({method: 'GET', path: "/pageNumber" ++ "?page=" ++ parameter.page ++ "&limit=" ++ parameter.limit})
        ---
        if (response.status == 200)
          success(response as HttpResponse<{items: Array<OutputRecord0>}>)
        else
          failure(response)
    }
}

type OutputWithCustomFields = @MetadataProvider(value = { name: "paginationCustomFieldsProvider" }) OutputRecord0

var paginatedCustomFields : Operation<Input0, Page<OutputWithCustomFields, Input0>, ResultFailure<HttpResponse, Error>, HttpConnection> =
  getPageNumber
    paginated (params, page) -> {
    items : page.body.items,
    (nextPage: {
        args: params update { case page at .page -> page + 1 }
    }) if !isEmpty(page.body.items)
  }
// paginated output object
type Input1 = {
  page: Number,
  limit: Number
}

var record6 : TypeValueDefinition =
  createObjectTypeValueDefinition("OutputRecord1")
  withField createField("field4", createNumberTypeValueDefinition())

var paginationOutputObjectProvider: MetadataProviderExecutor<{}, {errorMessage: String}, HttpConnection> =
    (key, conn) -> success(record6)

var getPageNumberOutputObject : Operation<Input0, HttpResponse<{items: Array<Object>}>, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "paginatedOutputObject",
    displayName: "paginatedOutputObject",
    executor: (parameter, connection) -> do {
        var response = connection({method: 'GET', path: "/pageNumber" ++ "?page=" ++ parameter.page ++ "&limit=" ++ parameter.limit})
        ---
        if (response.status == 200)
          success(response as HttpResponse<{items: Array<Object>}>)
        else
          failure(response)
    }
}

var paginatedOutputObject : Operation<Input1, Page<@MetadataProvider(value = { name: "paginationOutputObjectProvider" }) Object, Input1>, ResultFailure<HttpResponse, Error>, HttpConnection> =
  getPageNumberOutputObject
    paginated (params, page) -> {
    items : page.body.items,
    (nextPage: {
        args: params update { case page at .page -> page + 1 }
    }) if !isEmpty(page.body.items)
  }


@OperationElement
var isAlive: Operation<{}, HttpResponse, ResultFailure<HttpResponse, Error>, HttpConnection> = {
    name: "isAlive",
    displayName: "Is alive",
    executor: (parameter, connection) -> success(
        	{
                contentType: "application/json",
                status: 200,
                headers: {},
                cookies: {}
    		})
}

@TestConnectionElement()
var testConnection = {
	validate: defineTestConnection(
        isAlive,
        (response) -> { isValid: response.value.status == 200 }
    )
}

@ConnectionElement()
var basicAuthConnection = defineBasicHttpConnectionProvider<BasicAuthSchema>(
                              (parameter) -> parameter,
                              (parameter) -> {baseUri: "http://localhost"
                              }
)

@TestConnector()
var connector = {
    name: "DataWeaveExtension",
    displayName: "Data Weave Extension",
    connections: {basicAuth: basicAuthConnection},
    testConnection: testConnection,
    operations: {
       outputObjectOperation: outputObjectOperation,
       nestedDynamicOutputFieldOperation: nestedDynamicOutputFieldOperation,
       outputObjectWithCustomFieldsOperation: outputObjectWithCustomFieldsOperation,
       nestedCustomFieldsOutputOperation: nestedCustomFieldsOutputOperation,
       paginatedCustomFields: paginatedCustomFields,
       paginatedOutputObject: paginatedOutputObject
    },
    valueProviders: {
    },
    metadataProviders: {
      outputObjectProvider: outputObjectProvider,
      nestedDynamicOutputFieldProvider: nestedDynamicOutputFieldProvider,
      outputObjectWithCustomFieldsProvider: outputObjectWithCustomFieldsProvider,
      nestedCustomFieldsOutputProvider: nestedCustomFieldsOutputProvider,
      paginationCustomFieldsProvider: paginationCustomFieldsProvider,
      paginationOutputObjectProvider: paginationOutputObjectProvider
    }
}
