/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.HttpAuthenticationType;
import java.util.Map;
import java.util.Objects;

public class Connection<C extends BaseConnectionProviderModel> {
    private final C provider;
    private final Object info;

    public Connection(C provider, Object info) {
        this.provider = (BaseConnectionProviderModel)Objects.requireNonNull(provider, "provider");
        this.info = Objects.requireNonNull(info, "info");
    }

    public static <C extends BaseConnectionProviderModel> Connection<C> of(C provider, Object info) {
        return new Connection<C>(provider, info);
    }

    public C getProvider() {
        return this.provider;
    }

    public Object getInfo() {
        return this.info;
    }

    public String toString() {
        Map map;
        HttpAuthenticationType authenticationType;
        StringBuilder sb = new StringBuilder();
        C c = this.provider;
        if (c instanceof ConnectionProviderModel) {
            ConnectionProviderModel p = (ConnectionProviderModel)c;
            sb.append(p.getName()).append(" - ");
        }
        Object s = (authenticationType = (HttpAuthenticationType)((BaseConnectionProviderModel)this.provider).getAuthenticationType()) == null ? "unknown auth" : authenticationType.getType();
        sb.append(s);
        Object object = this.info;
        if (object instanceof Map && (object = (map = (Map)object).get("username")) instanceof String) {
            String username = (String)object;
            sb.append(": ").append(username);
        }
        return sb.toString();
    }
}

