/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.runtime.BindingValue;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;

class DataWeaveCall
implements AutoCloseable {
    private final ScriptingBindings bindings;
    private final Set<String> boundNames = new HashSet<String>();
    private final ModelInterpreterConfig config;
    private final DataWeaveScriptingEngine dataWeaveEngine;
    protected final List<ExecuteResult> closeables = new ArrayList<ExecuteResult>();
    private boolean frozen = false;
    private static final ScriptingBindings EMPTY_BINDINGS = ScriptingBindings.apply();

    DataWeaveCall(ModelInterpreterConfig config, DataWeaveScriptingEngine dataWeaveEngine) {
        this(config, dataWeaveEngine, ScriptingBindings.apply());
    }

    private DataWeaveCall(ModelInterpreterConfig config, DataWeaveScriptingEngine dataWeaveEngine, ScriptingBindings bindings) {
        this.config = Objects.requireNonNull(config);
        this.dataWeaveEngine = Objects.requireNonNull(dataWeaveEngine);
        this.bindings = bindings;
        this.boundNames.addAll(Arrays.asList(bindings.bindingNames()));
    }

    DataWeaveCall bind(String name, @Nullable Object value) {
        Objects.requireNonNull(name, "Name cannot be null");
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot bind a value to a frozen call");
        }
        if (value instanceof ExecuteResult) {
            ExecuteResult executeResult = (ExecuteResult)value;
            this.checkDuplicateBinding(name);
            this.bindings.addBinding(name, executeResult.getResultMaterialized());
        } else {
            if (value instanceof Model) {
                Model model = (Model)value;
                ExecuteResult res = this.doExecute(this.getFromCacheOrCompile(ModelInterpreter.getModelReference(model), new String[0]), EMPTY_BINDINGS);
                this.closeables.add(res);
                return this.bind(name, res);
            }
            if (value instanceof Connection) {
                ExecuteResult connectedConnection;
                Connection connection = (Connection)value;
                try (DataWeaveCall call = new DataWeaveCall(this.config, this.dataWeaveEngine);){
                    connectedConnection = call.bind("provider", connection.getProvider()).bind("info", connection.getInfo()).execute("provider.connect(info)").getExecuteResult();
                }
                this.closeables.add(connectedConnection);
                return this.bind(name, connectedConnection);
            }
            this.checkDuplicateBinding(name);
            this.bindings.addBinding(name, BindingValue.apply((Object)value, (String)"application/java"));
        }
        return this;
    }

    private static ScriptingBindings cloneBindings(ScriptingBindings bindings) {
        ScriptingBindings newBindings = ScriptingBindings.apply();
        bindings.bindings().foreach(t -> newBindings.addBinding((String)t._1, (BindingValue)t._2));
        bindings.literalValues().foreach(t -> newBindings.addBinding((String)t._1, (Value)t._2));
        return newBindings;
    }

    private void checkDuplicateBinding(String name) {
        if (!this.boundNames.add(name)) {
            throw new IllegalStateException("Duplicate binding: " + name);
        }
    }

    public DataWeaveLiveValue execute(String scriptText) {
        ExecuteResult result = this.doExecute(this.compile(scriptText), this.bindings);
        return new DataWeaveLiveValue(result, this.config, this.dataWeaveEngine);
    }

    private ExecuteResult doExecute(DataWeaveScript script, ScriptingBindings bindings) {
        try {
            return script.exec(bindings, this.config.getServiceManager());
        }
        catch (Exception e) {
            this.logViaDWService(e);
            throw e;
        }
    }

    @Nullable Object write(String scriptText) {
        DataWeaveScript script = this.compile(scriptText);
        try {
            return script.write(this.bindings, this.config.getServiceManager(), "application/java").getContent();
        }
        catch (Exception e) {
            this.logViaDWService(e);
            throw e;
        }
    }

    public DataWeaveCall newCall() {
        return new DataWeaveCall(this.config, this.dataWeaveEngine, DataWeaveCall.cloneBindings(this.bindings));
    }

    private DataWeaveScript compile(String scriptText) {
        return this.getFromCacheOrCompile(scriptText, this.bindings.bindingNames());
    }

    private DataWeaveScript getFromCacheOrCompile(String scriptText, String[] names) {
        return this.config.getCache().computeIfAbsent(scriptText, k -> {
            try {
                return this.dataWeaveEngine.compile(scriptText, names);
            }
            catch (Exception e) {
                this.logViaDWService(e);
                throw e;
            }
        });
    }

    private void logViaDWService(Exception e) {
        this.dataWeaveEngine.loggingService().exists(service -> {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            service.logError(String.format("Dataweave execution failed: %s", sw));
            return null;
        });
    }

    protected void freeze() {
        this.frozen = true;
    }

    protected boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public synchronized void close() {
        Exception primaryException = null;
        for (ExecuteResult closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (primaryException == null) {
                    primaryException = e;
                    continue;
                }
                primaryException.addSuppressed(e);
            }
        }
        if (primaryException != null) {
            throw new IllegalStateException("Exception while closing DataWeaveCall", primaryException);
        }
    }
}

