/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import java.util.Set;

public final class ModelReferenceOperations {
    private static final Set<String> RESERVED_WORDS = Set.of("if", "else", "unless", "using", "---", "as", "is", "null", "true", "false", "default", "case", "fun", "input", "output", "ns", "type", "import", "var", "and", "or", "throw", "do", "for", "yield", "enum", "private", "async");

    private ModelReferenceOperations() {
    }

    public static String innerFieldReference(String base, String ... path) {
        StringBuilder result = new StringBuilder(base);
        for (String field : path) {
            result.append('.');
            if (ModelReferenceOperations.shouldEscape(field)) {
                result.append('\"');
                result.append(ModelReferenceOperations.escape(field));
                result.append('\"');
                continue;
            }
            result.append(field);
        }
        return result.toString();
    }

    private static boolean shouldEscape(String field) {
        return !ModelReferenceOperations.isASCIIAlphabetic(field) || ModelReferenceOperations.isReservedWord(field);
    }

    private static boolean isASCIIAlphabetic(String text) {
        return text.chars().allMatch(c -> 97 <= c && c <= 122 || 65 <= c && c <= 90);
    }

    private static boolean isReservedWord(String text) {
        return RESERVED_WORDS.contains(text);
    }

    private static String escape(String text) {
        return text.replaceAll("[\"$]", "\\\\$0");
    }
}

