/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;

public class TypeModel
extends Model {
    private final DWType dataType;

    private TypeModel(@Nullable String modelReference, DWType dataType) {
        super(modelReference);
        this.dataType = dataType;
    }

    public DWType getDataType() {
        return this.dataType;
    }

    public static class Builder
    extends Model.Builder<TypeModel, Builder> {
        private @Nullable DWType dataType;

        public Builder withDataType(DWType dataType) {
            this.dataType = dataType;
            return this.getThis();
        }

        @Override
        protected TypeModel createInstance() {
            DWType type = Objects.requireNonNull(this.dataType, "dataType");
            if (this.modelReference == null) {
                this.modelReference = TypeUtils.weaveTypeToModelReference(type);
            }
            return new TypeModel(this.modelReference, type);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

