/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.operation;

import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;

class EagerResultError
implements ResultError {
    private static final long serialVersionUID = 1L;
    private final @Nullable String description;
    private final Object value;
    private final String kind;
    private final Set<String> categories;
    private final Map<String, Object> additionalProperties;

    EagerResultError(@Nullable String description, Object value, String kind, @Nullable Collection<String> categories, @Nullable Map<String, Object> additionalProperties) {
        this.description = description;
        this.value = Objects.requireNonNull(value, "'value' cannot be null");
        this.kind = Objects.requireNonNull(kind, "'kind' cannot be null");
        this.categories = categories == null ? Set.of() : Set.copyOf(categories);
        this.additionalProperties = additionalProperties == null ? Map.of() : Map.copyOf(additionalProperties);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Optional<Content> asContent() {
        return Optional.empty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    public Optional<Object> get(String property) {
        return Optional.ofNullable(this.additionalProperties.get(property));
    }

    @Override
    public Optional<ResultError> getCause() {
        Object v;
        Map cause = this.get("cause").filter(Map.class::isInstance).map(Map.class::cast).orElse(null);
        if (cause != null && (v = cause.get("kind")) instanceof String) {
            String causeKind = (String)v;
            v = cause.get("categories");
            if (v instanceof Collection) {
                Collection causeCategories = (Collection)v;
                return Optional.of(new EagerResultError(null, this.value, causeKind, causeCategories, Map.of()));
            }
        }
        return Optional.empty();
    }

    @Override
    public ResultError asJsonSerializable() {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResultError{");
        if (this.description != null) {
            sb.append("description='").append(this.description).append("', ");
        }
        sb.append("value=").append(this.value).append(", kind='").append(this.kind).append("', categories=").append(this.categories);
        if (!this.additionalProperties.isEmpty()) {
            sb.append(", additionalProperties=").append(this.additionalProperties);
        }
        return sb.append('}').toString();
    }
}

