/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import org.mule.weave.v2.utils.StringEscapeHelper;

public class DWTypeUtils {
    private DWTypeUtils() {
    }

    public static Optional<KeyValuePairType> getFieldByName(ObjectType objectType, String name) {
        return Arrays.stream(objectType.getProperties()).filter(property -> DWTypeUtils.getKey(property).equals(name)).findFirst();
    }

    public static String getKey(KeyValuePairType field) {
        String keyName = field.getKeyName();
        if (StringEscapeHelper.keyRequiresQuotes((String)keyName)) {
            keyName = StringEscapeHelper.unescapeString((String)keyName, (char)'\"', (Location)UnknownLocation$.MODULE$);
        }
        return keyName;
    }

    public static KeyValuePairType requireFieldByName(ObjectType objectType, String name) {
        return DWTypeUtils.getFieldByName(objectType, name).orElseThrow(() -> new NoSuchElementException("Type has no field with name '" + name + "'"));
    }
}

