/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProviderReference;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;

public class DynamicMetadataInputTest
extends AbstractConnectivityModelTest {
    private final ModelInterpreter modelInterpreter = new ModelInterpreter(dataWeaveScriptingEngine, new ModelInterpreterConfig.Builder().build());

    @Test
    void rootLevelDynamicField() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::InputMetadata");
        OperationModel operation = connectorModel.getOperation("rootLevelDynamicFieldOperation");
        DWType recordField = ((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)((ObjectType)TypeUtils.resolveReferenceType((DWType)operation.getInputType().getDataType())), (String)"record").orElseThrow()).getValue();
        ProviderReference reference = (ProviderReference)MetadataUtils.getMetadataProvider((DWType)recordField).orElseThrow();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"rootLevelDynamicFieldProvider"));
        ObjectType newFieldType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        KeyValuePairType fieldId = Stream.of(newFieldType.getProperties()).filter(field -> field.getKeyName().equals("id")).findFirst().orElseThrow();
        MatcherAssert.assertThat((Object)fieldId.getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
    }

    @Test
    void dynamicNestedField() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::InputMetadata");
        OperationModel operation = connectorModel.getOperation("nestedDynamicFieldOperation");
        ProviderReference reference = (ProviderReference)operation.getInputMetadataProviderReferenceFor(ObjectFieldSelector.create((String)"/record/dynamicField")).get();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"nestedDynamicFieldProvider"));
        ObjectType newFieldType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        KeyValuePairType fieldId = Stream.of(newFieldType.getProperties()).filter(field -> field.getKeyName().equals("id")).findFirst().orElseThrow();
        MatcherAssert.assertThat((Object)fieldId.getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
    }

    @Test
    void rootLevelCustomFields() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::InputMetadata");
        OperationModel operation = connectorModel.getOperation("rootLevelCustomFieldsOperation");
        DWType recordField = ((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)((ObjectType)TypeUtils.resolveReferenceType((DWType)operation.getInputType().getDataType())), (String)"record").orElseThrow()).getValue();
        ProviderReference reference = (ProviderReference)MetadataUtils.getMetadataProvider((DWType)recordField).orElseThrow();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"rootLevelCustomFieldsProvider"));
        ObjectType newFieldType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        KeyValuePairType fieldId = Stream.of(newFieldType.getProperties()).filter(field -> field.getKeyName().equals("id")).findFirst().orElseThrow();
        MatcherAssert.assertThat((Object)fieldId.getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
        KeyValuePairType field0 = Stream.of(newFieldType.getProperties()).filter(field -> field.getKeyName().equals("field0")).findFirst().orElseThrow();
        MatcherAssert.assertThat((Object)field0.getValue(), (Matcher)Matchers.instanceOf(StringType.class));
    }

    @Test
    void nestedCustomFields() {
        TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("metadataProviderInjection::InputMetadata");
        OperationModel operation = connectorModel.getOperation("nestedCustomFieldsOperation");
        ObjectType recordField = (ObjectType)((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)((ObjectType)TypeUtils.resolveReferenceType((DWType)operation.getInputType().getDataType())), (String)"record").orElseThrow()).getValue();
        DWType dynamicField = ((KeyValuePairType)DWTypeUtils.getFieldByName((ObjectType)recordField, (String)"dynamicField").orElseThrow()).getValue();
        ProviderReference reference = (ProviderReference)MetadataUtils.getMetadataProvider((DWType)dynamicField).orElseThrow();
        MatcherAssert.assertThat((Object)reference.getName(), (Matcher)Matchers.equalTo((Object)"nestedCustomFieldsProvider"));
        ObjectType newFieldType = (ObjectType)this.executeMetadataProvider(connectorModel, reference.getName());
        KeyValuePairType fieldId = Stream.of(newFieldType.getProperties()).filter(field -> field.getKeyName().equals("id")).findFirst().orElseThrow();
        MatcherAssert.assertThat((Object)fieldId.getValue(), (Matcher)Matchers.instanceOf(NumberType.class));
        KeyValuePairType field1 = Stream.of(newFieldType.getProperties()).filter(field -> field.getKeyName().equals("field1")).findFirst().orElseThrow();
        MatcherAssert.assertThat((Object)field1.getValue(), (Matcher)Matchers.instanceOf(StringType.class));
    }

    private DWType executeMetadataProvider(TestConnectorModel connectorModel, String providerName) {
        MetadataProviderModel metadataProvider = connectorModel.getMetadataProvider(providerName);
        return (DWType)this.modelInterpreter.executeMetadataProvider(connectorModel.getConnectionProviders().get(0), this.createConnectionInfo(), metadataProvider, Map.of()).getValue();
    }

    private Map<String, Object> createConnectionInfo() {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("baseUri", "http://api.acme.com/v1");
        connectionInfo.put("user", "jdoe");
        connectionInfo.put("pass", "secret");
        return connectionInfo;
    }
}

