/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.matchers;

import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;

public class ObjectFieldMatcher
extends TypeSafeMatcher<KeyValuePairType> {
    private final String name;
    private final Class<?> type;
    private final Boolean required;

    public ObjectFieldMatcher(String name, Class<?> type, Boolean required) {
        this.name = name;
        this.type = type;
        this.required = required;
    }

    protected boolean matchesSafely(KeyValuePairType item) {
        boolean sameName = this.name == null ? item.getKeyName() == null : this.name.equals(item.getKeyName());
        boolean sameRequired = true;
        if (Objects.nonNull(this.required)) {
            sameRequired = this.required.booleanValue() != item.isOptionalKey();
        }
        boolean sameTypeClass = this.type.isInstance(item.getValue());
        return sameName && sameRequired && sameTypeClass;
    }

    public void describeTo(Description description) {
        description.appendText("an object field with name = ").appendValue((Object)this.name).appendText(", required = ").appendValue((Object)this.required).appendText(", type = ").appendValue((Object)this.type.getName());
    }

    public static ObjectFieldMatcher fieldLike(String name, Class<?> type, boolean required) {
        return new ObjectFieldMatcher(name, type, required);
    }

    public static ObjectFieldMatcher fieldLike(String name, Class<?> type) {
        return new ObjectFieldMatcher(name, type, null);
    }
}

