/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.connector;

import com.mulesoft.connectivity.linkweave.api.model.ConnectorModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class TestConnectorModel
extends ConnectorModel {
    protected final @Nullable String description;
    protected final @Nullable TestConnectionModel testConnection;
    protected final List<ConnectionProviderModel> connectionProviders;
    protected final List<OperationModel> operations;
    protected final List<TriggerModel> triggers;
    protected final List<ValueProviderModel> valueProviders;
    protected final List<MetadataProviderModel> metadataProviders;

    protected TestConnectorModel(String name, String displayName, @Nullable String description, @Nullable TestConnectionModel testConnection, List<ConnectionProviderModel> connectionProviders, List<OperationModel> operations, List<TriggerModel> triggers, List<ValueProviderModel> valueProviders, List<MetadataProviderModel> metadataProviders, @Nullable String modelReference) {
        super(modelReference, name, displayName);
        this.description = description;
        this.testConnection = testConnection;
        this.connectionProviders = connectionProviders;
        this.operations = operations;
        this.triggers = triggers;
        this.valueProviders = valueProviders;
        this.metadataProviders = metadataProviders;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public List<ConnectionProviderModel> getConnectionProviders() {
        return this.connectionProviders;
    }

    public @Nullable TestConnectionModel getTestConnection() {
        return this.testConnection;
    }

    public List<OperationModel> getOperations() {
        return this.operations;
    }

    public OperationModel getOperation(String operationName) {
        return this.getOperations().stream().filter(operation -> operation.getName().equals(operationName)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find operation '" + operationName + "'"));
    }

    public List<TriggerModel> getTriggers() {
        return this.triggers;
    }

    public TriggerModel getTrigger(String triggerName) {
        return this.getTriggers().stream().filter(trigger -> trigger.getName().equals(triggerName)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find trigger '" + triggerName + "'"));
    }

    public List<ValueProviderModel> getValueProviders() {
        return this.valueProviders;
    }

    public ValueProviderModel getValueProvider(String name) {
        return this.getValueProviders().stream().filter(valueProvider -> valueProvider.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find value provider '" + name + "'"));
    }

    public List<MetadataProviderModel> getMetadataProviders() {
        return this.metadataProviders;
    }

    public MetadataProviderModel getMetadataProvider(String name) {
        return this.getMetadataProviders().stream().filter(provider -> provider.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find metadata provider '" + name + "'"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ConnectorModel{name='" + this.getName() + "'displayName='" + this.getDisplayName() + "'description='" + this.description + "'connectionProviders='" + String.valueOf(this.connectionProviders) + "'testConnection='" + String.valueOf(this.testConnection) + "'operations='" + String.valueOf(this.operations) + "'triggers='" + String.valueOf(this.triggers) + "'valueProviders='" + String.valueOf(this.valueProviders) + "'}";
    }

    public static class Builder
    extends ConnectorModel.Builder<TestConnectorModel, Builder> {
        protected @Nullable String description;
        protected @Nullable TestConnectionModel testConnection;
        protected final List<ConnectionProviderModel> connectionProviders = new ArrayList<ConnectionProviderModel>();
        protected final List<OperationModel> operations = new ArrayList<OperationModel>();
        protected final List<TriggerModel> triggers = new ArrayList<TriggerModel>();
        protected final List<ValueProviderModel> valueProviders = new ArrayList<ValueProviderModel>();
        protected final List<MetadataProviderModel> metadataProviders = new ArrayList<MetadataProviderModel>();

        public Builder withOperation(OperationModel operationModel) {
            this.operations.add(operationModel);
            return this.getThis();
        }

        public Builder withTrigger(TriggerModel triggerModel) {
            this.triggers.add(triggerModel);
            return this.getThis();
        }

        public Builder withDescription(@Nullable String description) {
            this.description = description;
            return this.getThis();
        }

        public Builder withTestConnection(TestConnectionModel testConnection) {
            this.testConnection = testConnection;
            return this.getThis();
        }

        public Builder addConnection(ConnectionProviderModel connectionProvider) {
            this.connectionProviders.add(connectionProvider);
            return this.getThis();
        }

        public Builder withValueProvider(ValueProviderModel valueProvider) {
            this.valueProviders.add(valueProvider);
            return this.getThis();
        }

        public Builder withMetadataProvider(MetadataProviderModel valueProvider) {
            this.metadataProviders.add(valueProvider);
            return this.getThis();
        }

        protected TestConnectorModel createInstance() {
            return new TestConnectorModel(Objects.requireNonNull(this.name, "name"), Objects.requireNonNull(this.displayName, "displayName"), this.description, this.testConnection, this.connectionProviders, this.operations, this.triggers, this.valueProviders, this.metadataProviders, this.modelReference);
        }

        protected Builder getThis() {
            return this;
        }
    }
}

