/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api;

import com.mulesoft.connectivity.linkweave.api.LWLogger;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.model.service.LoggingService;

public class LWLoggerTest {
    private static String logString = "";

    @Test
    void testLWLogger() {
        try {
            Field field = LWLogger.class.getDeclaredField("loggingService");
            field.setAccessible(true);
            Object currentLogger = field.get(null);
            Field julLoggerField = currentLogger.getClass().getDeclaredField("logger");
            julLoggerField.setAccessible(true);
            Logger julLogger = (Logger)julLoggerField.get(currentLogger);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamHandler handler = new StreamHandler(baos, new SimpleFormatter());
            handler.setLevel(Level.ALL);
            julLogger.addHandler(handler);
            julLogger.setUseParentHandlers(false);
            LWLogger.logInfo((String)"info");
            LWLogger.logWarn((String)"warning");
            LWLogger.logDebug((String)"debug");
            LWLogger.logError((String)"error");
            handler.flush();
            List<String> output = baos.toString().lines().toList();
            Assertions.assertTrue((boolean)output.stream().anyMatch(line -> line.contains("LW - info")));
            Assertions.assertTrue((boolean)output.stream().anyMatch(line -> line.contains("LW - warning")));
            Assertions.assertFalse((boolean)output.stream().anyMatch(line -> line.contains("LW - debug")));
            Assertions.assertTrue((boolean)output.stream().anyMatch(line -> line.contains("LW - error")));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        LWLogger.set((LoggingService)new LoggingService(){

            public boolean isDebugEnabled() {
                return false;
            }

            public boolean isInfoEnabled() {
                return false;
            }

            public void logInfo(String msg) {
                logString = logString + msg;
            }

            public void logError(String msg) {
                logString = logString + msg;
            }

            public void logWarn(String msg) {
                logString = logString + msg;
            }

            public void logDebug(String msg) {
                logString = logString + msg;
            }
        });
        LWLogger.logInfo((String)"info");
        LWLogger.logError((String)"error");
        LWLogger.logWarn((String)"warning");
        LWLogger.logDebug((String)"debug");
        Assertions.assertFalse((boolean)logString.contains("LW - info"));
        Assertions.assertTrue((boolean)logString.contains("LW - error"));
        Assertions.assertTrue((boolean)logString.contains("LW - warning"));
        Assertions.assertFalse((boolean)logString.contains("LW - debug"));
    }
}

