/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.LWLogger;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.EagerPage;
import com.mulesoft.connectivity.linkweave.api.interpreter.LWConnection;
import com.mulesoft.connectivity.linkweave.api.interpreter.LazyPage;
import com.mulesoft.connectivity.linkweave.api.interpreter.LazyResultError;
import com.mulesoft.connectivity.linkweave.api.interpreter.LazyTriggerPage;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.interpreter.Page;
import com.mulesoft.connectivity.linkweave.api.interpreter.Result;
import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.provider.MetadataProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import com.mulesoft.connectivity.linkweave.api.util.SerializationUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.ts.TypeType;

public class ModelInterpreter {
    private final DataWeaveScriptingEngine dataWeaveEngine;
    private final ModelInterpreterConfig config;
    private final SerializationUtil serializationUtil;
    private static final Function<Content, ? extends Page<ProvidedValue>> VALUE_PROVIDER_TO_PAGE = EagerPage.factory().getBuilderFunction(false, ProvidedValue::fromData).compose(Content::get);
    private static final Function<Content, ? extends Page<ProvidedValue>> VALUE_PROVIDER_TO_PAGE_PAGINATED = EagerPage.factory().getBuilderFunction(true, ProvidedValue::fromData).compose(Content::get);

    public ModelInterpreter(DataWeaveScriptingEngine dataWeaveEngine) {
        this(dataWeaveEngine, new ModelInterpreterConfig.Builder().build());
    }

    public ModelInterpreter(DataWeaveScriptingEngine engine, ModelInterpreterConfig config) {
        this.dataWeaveEngine = engine;
        this.config = config;
        this.serializationUtil = new SerializationUtil(engine, config);
    }

    public SerializationUtil getSerializationUtil() {
        return this.serializationUtil;
    }

    @Deprecated(since="1.4.0")
    public ConnectionValidationResult testConnection(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo) {
        LWLogger.logInfo(String.format("Executing testConnection with platform managed connection with null test connection modelfor connection provider %s", connectionProviderModel.getModelReference().orElse("empty")));
        return this.testConnection((TestConnectionModel)null, Connection.of(connectionProviderModel, connectionInfo));
    }

    @Deprecated(since="1.4.0")
    public ConnectionValidationResult testConnection(@Nullable TestConnectionModel testConnectionModel, BaseConnectionProviderModel connectionProviderModel, Object connectionInfo) {
        return this.testConnection(testConnectionModel, Connection.of(connectionProviderModel, connectionInfo));
    }

    public ConnectionValidationResult testConnection(@Nullable TestConnectionModel testConnectionModel, Connection<?> connection) {
        LWLogger.logInfo(String.format("Executing testConnectionfor connection provider %s", ((Model)connection.getProvider()).getModelReference().orElse("empty")));
        Object obj = connection.getProvider();
        if (obj instanceof BaseConnectionProviderModel) {
            BaseConnectionProviderModel bcpm = (BaseConnectionProviderModel)obj;
            if (testConnectionModel == null) {
                testConnectionModel = bcpm.getTestConnection();
            }
            if (testConnectionModel == null) {
                throw new IllegalStateException(String.format("No 'validate' function found in %s to run a test connection", ModelInterpreter.getModelReference(connection.getProvider())));
            }
        } else if (testConnectionModel == null) {
            throw new IllegalArgumentException("Test connection model must not be null when connection is of " + String.valueOf(connection.getClass()));
        }
        try (DataWeaveCall call = this.call();){
            ConnectionValidationResult connectionValidationResult;
            block17: {
                DataWeaveLiveValue result = call.bind("connection", connection).bind("testConnection", testConnectionModel).when(() -> "testing connection " + String.valueOf(connection.getProvider())).eval("testConnection.validate(connection)");
                try {
                    Boolean isValid = result.selectBoolean("isValid").orElseThrow(() -> new IllegalStateException("'validate' function did not specify if the connection is valid"));
                    ConnectionValidationResult connectionValidationResult2 = connectionValidationResult = isValid != false ? ConnectionValidationResult.success() : ConnectionValidationResult.failure((String)result.evalToNullableJava("result.message"), (String)result.evalToNullableJava("result.error"));
                    if (result == null) break block17;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return connectionValidationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public List<Map<?, ?>> executeResolveConnectionExtensions(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo) {
        return this.executeResolveConnectionExtensions(Connection.of(connectionProviderModel, connectionInfo));
    }

    public List<Map<?, ?>> executeResolveConnectionExtensions(Connection<?> connection) {
        if (!(connection instanceof LWConnection)) {
            throw new IllegalArgumentException("Connection must be an instance of LWConnection");
        }
        try (DataWeaveCall call = this.call();){
            List list = (List)call.bind("provider", connection.getProvider()).bind("info", connection.getInfo()).when(() -> "resolving connection extensions").evalToNullableJava("provider.extensions(info)");
            return list;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<Object> executeOperation(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> operationModel, Object parameters) {
        return this.executeOperation(Connection.of(connectionProviderModel, connectionInfo), operationModel, parameters).map(v -> {
            if (v instanceof Page) {
                return v;
            }
            if (v instanceof Content) {
                Content content;
                try (Content content2 = content = (Content)v;){
                    Object object = content.get();
                    return object;
                }
            }
            throw new IllegalStateException(String.format("Expected a Page or a Content, got %s", v.getClass()));
        });
    }

    public OperationResult<? extends Result> executeOperation(Connection<?> connection, BaseExecutableComponentModel<?> operationModel, Object parameters) {
        LWLogger.logInfo(String.format("Executing executeOperation %s for connection provider %s", operationModel.getModelReference().orElse("empty"), ((Model)connection.getProvider()).getModelReference().orElse("empty")));
        String scriptText = "com::mulesoft::connectivity::Runtime::executeOperation(operation, parameters, connection)";
        try (DataWeaveCall call = this.call();){
            DataWeaveLiveValue result = call.bind("connection", connection).bind("operation", operationModel).bind("parameters", parameters).when(() -> "executing operation '" + operationModel.getName() + "'").eval(scriptText);
            OperationResult<Result> operationResult = ModelInterpreter.intoOperationResult(result).map(operationModel.isPaginated() ? LazyPage::new : Content::new);
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<? extends Result> executeOperationNextPage(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> operationModel, Object nextPageData) {
        return this.executeOperationNextPage(Connection.of(connectionProviderModel, connectionInfo), operationModel, nextPageData);
    }

    public OperationResult<? extends Result> executeOperationNextPage(Connection<?> connection, BaseExecutableComponentModel<?> operationModel, Object nextPageData) {
        LWLogger.logInfo(String.format("Executing executeOperationNextPage %s for connection provider %s", operationModel.getModelReference().orElse("empty"), ((Model)connection.getProvider()).getModelReference().orElse("empty")));
        if (!operationModel.isPaginated()) {
            throw new IllegalArgumentException("Operation " + operationModel.getModelReference().orElseGet(operationModel::getName) + " is not paginated");
        }
        Object parameters = ((Map)nextPageData).get("args");
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::executePaginatedOperationNextPage(operation, parameters, connection)";
            DataWeaveLiveValue result = call.bind("connection", connection).bind("operation", operationModel).bind("parameters", parameters).when(() -> "executing operation '" + operationModel.getName() + "' (next page)").eval(scriptText);
            OperationResult<LazyPage> operationResult = ModelInterpreter.intoOperationResult(result).map(LazyPage::new);
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<TriggerPage<? extends TriggerItem>> executeTrigger(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> triggerModel, Object watermark, Object parameters) {
        return this.executeTrigger(Connection.of(connectionProviderModel, connectionInfo), triggerModel, watermark, parameters);
    }

    public OperationResult<TriggerPage<? extends TriggerItem>> executeTrigger(Connection<?> connection, BaseExecutableComponentModel<?> triggerModel, Object watermark, Object parameters) {
        LWLogger.logInfo(String.format("Executing executeTrigger %s for connection provider %s with watermark %s", triggerModel.getModelReference().orElse("empty"), ((Model)connection.getProvider()).getModelReference().orElse("empty"), watermark));
        Objects.requireNonNull(watermark);
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::serializeTriggerResponseIfSuccess(\n  com::mulesoft::connectivity::Runtime::executeTrigger(\n    trigger,\n    com::mulesoft::connectivity::Runtime::deserializeObject(watermark),\n    parameters,\n    connection))";
            DataWeaveLiveValue result = call.bind("connection", connection).bind("trigger", triggerModel).bind("watermark", watermark).bind("parameters", parameters).when(() -> "executing trigger '" + triggerModel.getName() + "'").eval(scriptText);
            OperationResult<TriggerPage<? extends TriggerItem>> operationResult = ModelInterpreter.intoOperationResult(result).map(LazyTriggerPage::new);
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<? extends TriggerPage<? extends TriggerItem>> executeTriggerNextPage(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> triggerModel, NextData nextData) {
        return this.executeTriggerNextPage(Connection.of(connectionProviderModel, connectionInfo), triggerModel, nextData);
    }

    public OperationResult<? extends TriggerPage<? extends TriggerItem>> executeTriggerNextPage(Connection<?> connection, BaseExecutableComponentModel<?> triggerModel, NextData nextData) {
        LWLogger.logInfo(String.format("Executing executeTriggerNextPage %s for connection provider %s", triggerModel.getModelReference().orElse("empty"), ((Model)connection.getProvider()).getModelReference().orElse("empty")));
        Serializable latestWatermarkObject = nextData.getNextPoll().getLatestWatermark();
        Serializable greatestWatermarkObject = nextData.getNextPoll().getGreatestWatermark();
        Serializable nextPageObject = nextData.getNextPage().orElseThrow();
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::serializeTriggerResponseIfSuccess(\n  com::mulesoft::connectivity::Runtime::executeTriggerNextPage(\n    trigger,\n    com::mulesoft::connectivity::Runtime::deserializeObject(serializedWatermark),\n    com::mulesoft::connectivity::Runtime::deserializeObject(serializedPartialGreatestWatermark),\n    com::mulesoft::connectivity::Runtime::deserializeObject(serializedParameters).args,\n    connection))";
            DataWeaveLiveValue result = call.bind("connection", connection).bind("trigger", triggerModel).bind("serializedWatermark", latestWatermarkObject).bind("serializedPartialGreatestWatermark", greatestWatermarkObject).bind("serializedParameters", nextPageObject).when(() -> "executing trigger '" + triggerModel.getName() + "' (next page)").eval(scriptText);
            OperationResult<LazyTriggerPage> operationResult = ModelInterpreter.intoOperationResult(result).map(LazyTriggerPage::new);
            return operationResult;
        }
    }

    public Integer executeTriggerCompareWatermark(BaseExecutableComponentModel<?> triggerModel, Object param1, Object param2) {
        LWLogger.logInfo(String.format("Executing executeTriggerCompareWatermark for trigger %s for params %s and %s", triggerModel.getModelReference().orElse("empty"), param1, param2));
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::executeTriggerCompareWatermark(trigger, arg1, arg2)";
            Integer n = Integer.parseInt(call.bind("trigger", triggerModel).bind("arg1", param1).bind("arg2", param2).when(() -> "executing trigger '" + triggerModel.getName() + "' watermark comparison").evalToJava(scriptText).toString());
            return n;
        }
    }

    @Deprecated(since="1.4.0")
    public Serializable getInitialWatermark(BaseConnectionProviderModel connectionProviderModel, Object connectionInfo, BaseExecutableComponentModel<?> triggerModel, Object parameters) {
        return this.getInitialWatermark(Connection.of(connectionProviderModel, connectionInfo), triggerModel, parameters);
    }

    public Serializable getInitialWatermark(Connection<?> connection, BaseExecutableComponentModel<?> triggerModel, Object parameters) {
        LWLogger.logInfo(String.format("Executing getInitialWatermark for trigger %s for connection provider %s", triggerModel.getModelReference().orElse("empty"), ((Model)connection.getProvider()).getModelReference().orElse("empty")));
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::serializeObject(\n  com::mulesoft::connectivity::Runtime::getInitialWatermark(trigger, parameters, connection))";
            Serializable serializable = (Serializable)call.bind("connection", connection).bind("trigger", triggerModel).bind("parameters", parameters).when(() -> "getting trigger '" + triggerModel.getName() + "' initial watermark").evalToJava(scriptText);
            return serializable;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<Page<ProvidedValue>> executeValueProvider(ConnectionProviderModel connectionProviderModel, Object connectionInfo, ValueProviderModel valueProviderModel, Object parameters) {
        return this.executeValueProvider(Connection.of(connectionProviderModel, connectionInfo), valueProviderModel, parameters);
    }

    public OperationResult<Page<ProvidedValue>> executeValueProvider(Connection<?> connection, ValueProviderModel valueProviderModel, Object parameters) {
        LWLogger.logInfo(String.format("Executing executeValueProvider for %s for connection provider %s", valueProviderModel.getModelReference().orElse("empty"), ((Model)connection.getProvider()).getModelReference().orElse("empty")));
        try (DataWeaveCall call = this.call();){
            boolean isPaginated = valueProviderModel.isPaginated();
            String script = isPaginated ? "com::mulesoft::connectivity::Runtime::executePaginatedValueProvider(valueProvider, parameters, connection)" : "com::mulesoft::connectivity::Runtime::executeValueProvider(valueProvider, parameters, connection)";
            OperationResult<Page<ProvidedValue>> operationResult = ModelInterpreter.intoOperationResult(call.bind("connection", connection).bind("valueProvider", valueProviderModel).bind("parameters", parameters).when(() -> "executing value provider '" + valueProviderModel.getName() + "'").eval(script)).map(lv -> {
                try (Content c = new Content((DataWeaveLiveValue)lv);){
                    Page<ProvidedValue> page = (isPaginated ? VALUE_PROVIDER_TO_PAGE_PAGINATED : VALUE_PROVIDER_TO_PAGE).apply(c);
                    return page;
                }
            });
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<Page<ProvidedValue>> executeValueProviderNextPage(ConnectionProviderModel connectionProviderModel, Object connectionInfo, ValueProviderModel valueProviderModel, Object nextPageData) {
        return this.executeValueProviderNextPage(Connection.of(connectionProviderModel, connectionInfo), valueProviderModel, nextPageData);
    }

    public OperationResult<Page<ProvidedValue>> executeValueProviderNextPage(Connection<?> connection, ValueProviderModel valueProviderModel, Object nextPageData) {
        LWLogger.logInfo(String.format("Executing executeValueProviderNextPage for %s for connection provider %s", valueProviderModel.getModelReference().orElse("empty"), ((Model)connection.getProvider()).getModelReference().orElse("empty")));
        try (DataWeaveCall call = this.call();){
            Object parameters = ((Map)nextPageData).get("args");
            String scriptText = "com::mulesoft::connectivity::Runtime::executePaginatedValueProviderNextPage(valueProvider, parameters, connection)";
            OperationResult<Page<ProvidedValue>> operationResult = ModelInterpreter.intoOperationResult(call.bind("connection", connection).bind("valueProvider", valueProviderModel).bind("parameters", parameters).when(() -> "executing value provider '" + valueProviderModel.getName() + "' (next page)").eval(scriptText)).map(lv -> {
                try (Content c = new Content((DataWeaveLiveValue)lv);){
                    Page<ProvidedValue> page = VALUE_PROVIDER_TO_PAGE_PAGINATED.apply(c);
                    return page;
                }
            });
            return operationResult;
        }
    }

    @Deprecated(since="1.4.0")
    public OperationResult<DWType> executeMetadataProvider(ConnectionProviderModel connectionProviderModel, Object connectionInfo, MetadataProviderModel metadataProviderModel, Object parameters) {
        return this.executeMetadataProvider(Connection.of(connectionProviderModel, connectionInfo), metadataProviderModel, parameters);
    }

    public OperationResult<DWType> executeMetadataProvider(Connection<?> connection, MetadataProviderModel metadataProviderModel, Object parameters) {
        LWLogger.logInfo(String.format("Executing executeMetadataProvider for %s for connection provider %s", metadataProviderModel.getModelReference().orElse("empty"), ((Model)connection.getProvider()).getModelReference().orElse("empty")));
        try (DataWeaveCall call = this.call();){
            String scriptText = "com::mulesoft::connectivity::Runtime::executeMetadataProvider(metadataProvider, parameters, connection)";
            OperationResult<DWType> operationResult = ModelInterpreter.intoOperationResult(call.bind("connection", connection).bind("metadataProvider", metadataProviderModel).bind("parameters", parameters).when(() -> "executing metadata provider '" + metadataProviderModel.getName() + "'").eval(scriptText)).map(v -> {
                try (Content c = new Content((DataWeaveLiveValue)v);){
                    DWType dWType = TypeUtils.resolveWeaveType(extendedType -> ((TypeType)this.dataWeaveEngine.inferTypeOf(extendedType).get()).getType(), (Map)Objects.requireNonNull(c.get(), "metadata provider result is null"));
                    return dWType;
                }
            });
            return operationResult;
        }
    }

    static String getModelReference(Model model) {
        return model.getModelReference().filter(Predicate.not(String::isEmpty)).orElseThrow(() -> new IllegalStateException("Model must have a valid selector set as model reference"));
    }

    private static OperationResult<DataWeaveLiveValue> intoOperationResult(DataWeaveLiveValue liveValue) {
        if (liveValue.selectBoolean("success").orElseThrow().booleanValue()) {
            DataWeaveLiveValue value = liveValue.eval("result.value");
            liveValue.close();
            return OperationResult.success(value);
        }
        return OperationResult.failure(new LazyResultError(liveValue));
    }

    DataWeaveCall call() {
        return new DataWeaveCall(this.config, this.dataWeaveEngine);
    }
}

