/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.DataWeaveObjectReference;
import com.mulesoft.connectivity.linkweave.api.DataWeaveReference;
import com.mulesoft.connectivity.linkweave.api.loader.ContextVariablesResolver;
import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import java.util.Objects;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;

public abstract class ExecutableComponentLoader<M extends ExecutableComponentModel<?>, B extends ExecutableComponentModel.ExecutableComponentBuilder<M, B>>
extends ModelLoader<M, B, DataWeaveObjectReference> {
    protected void configureInputType(B builder, TypeModel inputType) {
        ((ExecutableComponentModel.ExecutableComponentBuilder)builder).withInputType(inputType);
        ((ExecutableComponentModel.ExecutableComponentBuilder)builder).resolvedInputProviders(ContextVariablesResolver.resolveContextVariablesOnInput(inputType.getDataType()));
    }

    protected void configureOutputType(B builder, TypeModel outputType, TypeModel inputType) {
        ((ExecutableComponentModel.ExecutableComponentBuilder)builder).withOutputType(outputType);
        ((ExecutableComponentModel.ExecutableComponentBuilder)builder).resolvedOutputProviders(ContextVariablesResolver.resolveContextVariablesOnOutput(outputType.getDataType(), inputType.getDataType()));
    }

    @Override
    protected B configureBuilder(B builder, DataWeaveObjectReference dwObject, @Nullable String name) {
        ((Model.Builder)((ExecutableComponentModel.ExecutableComponentBuilder)((ExecutableComponentModel.ExecutableComponentBuilder)builder).withName(ExecutableComponentLoader.getName(dwObject, name))).withDisplayName(dwObject.requireProperty("displayName").asString())).withModelReference(dwObject.getPath());
        this.configureImplementation(builder, dwObject);
        this.configureVersions(builder, dwObject, name);
        return builder;
    }

    private static String getName(DataWeaveObjectReference dwObject, @Nullable String name) {
        return dwObject.getProperty("name").map(DataWeaveReference::asString).orElseGet(() -> Objects.requireNonNull(name, "Component at '" + dwObject.getPath() + "' must have a name."));
    }

    private void configureVersions(B builder, DataWeaveObjectReference dwObject, @Nullable String name) {
        dwObject.getObjectProperty("versions").ifPresent(vv -> {
            TreeMap m = new TreeMap();
            vv.forEachProperty((versionString, executableData) -> {
                int version;
                try {
                    version = Integer.parseInt(versionString.trim());
                }
                catch (NumberFormatException e) {
                    throw new InvalidConnectorException("The version must be a number, but it's '" + versionString + "'.", vv.getPropertyLocation((String)versionString));
                }
                if (version == 1) {
                    throw new InvalidConnectorException("Version 1 is reserved for the base operation.", vv.getPropertyLocation((String)versionString));
                }
                DataWeaveObjectReference objectReference = executableData.asObjectReference();
                ExecutableComponentModel.ExecutableComponentBuilder versionBuilder = (ExecutableComponentModel.ExecutableComponentBuilder)((Model.Builder)((ExecutableComponentModel.ExecutableComponentBuilder)((ExecutableComponentModel.ExecutableComponentBuilder)this.createBuilder()).withName(ExecutableComponentLoader.getName(dwObject, name))).withDisplayName(dwObject.requireProperty("displayName").asString())).withModelReference(objectReference.getPath());
                this.configureImplementation(versionBuilder, objectReference);
                versionBuilder.withIsBase(false);
                m.put(version, (ExecutableComponentModel)versionBuilder.build());
            });
            builder.withVersions(m);
        });
    }

    protected abstract void configureImplementation(B var1, DataWeaveObjectReference var2);
}

