/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.EagerPage;
import com.mulesoft.connectivity.linkweave.api.interpreter.Page;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.core.exception.UserException;

class LazyPage<T>
implements Page<T> {
    private final DataWeaveLiveValue liveValue;

    LazyPage(DataWeaveLiveValue liveValue) {
        this.liveValue = liveValue;
    }

    @Override
    public List<T> getItems() {
        return new AbstractList<T>(){
            @Nullable Integer size = null;

            @Override
            public T get(int index) {
                try (DataWeaveCall call = LazyPage.this.liveValue.call();){
                    call.bind("i", index);
                    Object t = LazyPage.this.getItem(call);
                    return t;
                }
            }

            @Override
            public int size() {
                if (this.size == null) {
                    this.size = (Integer)LazyPage.this.liveValue.evalToJava("sizeOf(result.items)");
                }
                return this.size;
            }
        };
    }

    protected T getItem(DataWeaveCall call) {
        return (T)call.evalToNullableJava("result.items[i]");
    }

    @Override
    public Optional<Iterator<Content>> getRawItems() {
        return Optional.of(new Iterator<Content>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                try (DataWeaveCall call = LazyPage.this.liveValue.call();){
                    call.bind("i", this.i);
                    boolean bl = Boolean.TRUE.equals(call.evalToJava("result.items[i]?"));
                    return bl;
                }
            }

            @Override
            public Content next() {
                DataWeaveCall call = LazyPage.this.liveValue.call();
                try {
                    call.bind("i", this.i++);
                    Content content = new Content(call.eval("if (result.items[i]?)\n  result.items[i] <~ result.^\nelse\n  dw::Runtime::fail(\"EOF\")\n"), true);
                    if (call != null) {
                        call.close();
                    }
                    return content;
                }
                catch (Throwable throwable) {
                    try {
                        if (call != null) {
                            try {
                                call.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (UserException e) {
                        if (e.getMessage().startsWith("EOF")) {
                            throw new NoSuchElementException();
                        }
                        throw e;
                    }
                }
            }
        });
    }

    @Override
    public Page<T> asJsonSerializable() {
        return new EagerPage<T>(this.getItems(), this.getNextPage().orElse(null));
    }

    @Override
    public Optional<Serializable> getNextPage() {
        return Optional.ofNullable((Serializable)this.liveValue.evalToNullableJava("result.nextPage"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64).append("Page{items=").append(this.getItems());
        this.getNextPage().ifPresent(np -> sb.append(", nextPage=").append(np));
        return sb.append('}').toString();
    }

    public boolean equals(@Nullable Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void close() {
        this.liveValue.close();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new EagerPage<T>(this.getItems(), this.getNextPage().orElse(null));
    }

    @Override
    public boolean isPage() {
        return true;
    }

    @Override
    public boolean isContent() {
        return false;
    }

    @Override
    public Page<?> asPage() {
        return this;
    }

    @Override
    public Content asContent() {
        throw new UnsupportedOperationException();
    }
}

