/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ConnectorExecutionException;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.core.exception.ExecutionException;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.runtime.BindingValue;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;

class DataWeaveCall
implements AutoCloseable {
    private final ScriptingBindings bindings;
    private final Set<String> boundNames = new HashSet<String>();
    private final ModelInterpreterConfig config;
    private final DataWeaveScriptingEngine dataWeaveEngine;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private boolean frozen = false;
    private int usageCount = 0;
    private @Nullable Supplier<String> when;
    private static final ScriptingBindings EMPTY_BINDINGS = ScriptingBindings.apply();

    DataWeaveCall(ModelInterpreterConfig config, DataWeaveScriptingEngine dataWeaveEngine) {
        this(config, dataWeaveEngine, ScriptingBindings.apply());
    }

    private DataWeaveCall(ModelInterpreterConfig config, DataWeaveScriptingEngine dataWeaveEngine, ScriptingBindings bindings) {
        this.config = Objects.requireNonNull(config);
        this.dataWeaveEngine = Objects.requireNonNull(dataWeaveEngine);
        this.bindings = bindings;
        this.boundNames.addAll(Arrays.asList(bindings.bindingNames()));
    }

    DataWeaveCall bind(String name, @Nullable Object value) {
        Objects.requireNonNull(name, "Name cannot be null");
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot bind a value to a frozen call");
        }
        if (value instanceof ExecuteResult) {
            ExecuteResult executeResult = (ExecuteResult)value;
            this.checkDuplicateBinding(name);
            this.bindings.addBinding(name, executeResult.getResultMaterialized());
        } else {
            if (value instanceof Model) {
                Model model = (Model)value;
                ExecuteResult res = this.doExecute(this.compile(ModelInterpreter.getModelReference(model), new String[0]), EMPTY_BINDINGS);
                this.registerCloseable((AutoCloseable)res);
                return this.bind(name, res);
            }
            if (value instanceof Connection) {
                ExecuteResult connectedConnection;
                Connection connection = (Connection)value;
                try (DataWeaveCall call = new DataWeaveCall(this.config, this.dataWeaveEngine);){
                    DataWeaveLiveValue lv = call.bind("provider", connection.getProvider()).bind("info", connection.getInfo()).when(() -> "executing connect on the connection provider" + (String)(this.when != null ? ", when " + this.when.get() : "")).eval("provider.connect(info)");
                    connectedConnection = lv.getExecuteResult();
                    this.registerCloseable(lv);
                }
                return this.bind(name, connectedConnection);
            }
            this.checkDuplicateBinding(name);
            this.bindings.addBinding(name, BindingValue.apply((Object)value, (String)"application/java"));
        }
        return this;
    }

    private static ScriptingBindings cloneBindings(ScriptingBindings bindings) {
        ScriptingBindings newBindings = ScriptingBindings.apply();
        bindings.bindings().foreach(t -> newBindings.addBinding((String)t._1, (BindingValue)t._2));
        bindings.literalValues().foreach(t -> newBindings.addBinding((String)t._1, (Value)t._2));
        return newBindings;
    }

    private void checkDuplicateBinding(String name) {
        if (!this.boundNames.add(name)) {
            throw new IllegalStateException("Duplicate binding: " + name);
        }
    }

    public DataWeaveLiveValue eval(String scriptText) {
        ExecuteResult result = this.doExecute(this.compile(scriptText), this.bindings);
        DataWeaveLiveValue liveValue = new DataWeaveLiveValue(result, this.config, this.dataWeaveEngine);
        liveValue.registerCloseable(this);
        ++this.usageCount;
        return liveValue;
    }

    protected void registerCloseable(AutoCloseable dataWeaveCall) {
        this.closeables.add(dataWeaveCall);
    }

    private ExecuteResult doExecute(DataWeaveScript script, ScriptingBindings bindings) {
        try {
            return script.exec(bindings, this.config.getServiceManager());
        }
        catch (Exception e) {
            ExecutionException executionException;
            block5: {
                block4: {
                    this.logViaDWService(e);
                    if (!(e instanceof ExecutionException)) break block4;
                    executionException = (ExecutionException)e;
                    if (this.when != null) break block5;
                }
                throw e;
            }
            throw new ConnectorExecutionException("Connector failed when " + this.when.get() + ": " + executionException.message(), executionException);
        }
    }

    @Nullable Object evalToNullableJava(String scriptText) {
        DataWeaveScript script = this.compile(scriptText);
        try {
            return script.write(this.bindings, this.config.getServiceManager(), "application/java").getContent();
        }
        catch (Exception e) {
            this.logViaDWService(e);
            throw e;
        }
    }

    Object evalToJava(String scriptText) {
        return Objects.requireNonNull(this.evalToNullableJava(scriptText), () -> "Evaluation of '" + scriptText + "' returned null");
    }

    public DataWeaveCall newCall() {
        return new DataWeaveCall(this.config, this.dataWeaveEngine, DataWeaveCall.cloneBindings(this.bindings));
    }

    public DataWeaveCall when(Supplier<String> when) {
        this.when = when;
        return this;
    }

    private DataWeaveScript compile(String scriptText) {
        return this.compile(scriptText, this.bindings.bindingNames());
    }

    private DataWeaveScript compile(String scriptText, String[] names) {
        return this.config.getCache().computeIfAbsent(scriptText, k -> {
            try {
                return this.dataWeaveEngine.compile(scriptText, names);
            }
            catch (Exception e) {
                this.logViaDWService(e);
                throw e;
            }
        });
    }

    private void logViaDWService(Exception e) {
        this.dataWeaveEngine.loggingService().exists(service -> {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            service.logError(String.format("Dataweave execution failed: %s", sw));
            return null;
        });
    }

    protected void freeze() {
        this.frozen = true;
    }

    protected boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public synchronized void close() {
        if (this.usageCount-- > 0) {
            return;
        }
        Exception primaryException = null;
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (primaryException == null) {
                    primaryException = e;
                    continue;
                }
                primaryException.addSuppressed(e);
            }
        }
        if (primaryException != null) {
            throw new IllegalStateException("Exception while closing DataWeaveCall", primaryException);
        }
    }
}

