/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.location.Location;
import org.mule.weave.v2.parser.location.WeaveLocation;

public class InvalidConnectorException
extends RuntimeException {
    private final @Nullable Location location;

    public InvalidConnectorException(String message, @Nullable Location location) {
        super(InvalidConnectorException.buildMessage(message, location));
        this.location = location;
    }

    public static Optional<WeaveLocation> lastLocation(List<Location> locations) {
        return locations.stream().filter(l -> l instanceof WeaveLocation).map(kv -> ((WeaveLocation)kv).endPosition()).max(Comparator.naturalOrder()).map(p -> {
            WeaveLocation weaveLocation;
            Object patt1471$temp = locations.get(0);
            if (patt1471$temp instanceof WeaveLocation) {
                WeaveLocation weaveLocation2 = (WeaveLocation)patt1471$temp;
                weaveLocation = new WeaveLocation(p, p, weaveLocation2.resourceName());
            } else {
                weaveLocation = null;
            }
            return weaveLocation;
        });
    }

    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.location);
    }

    private static String buildMessage(String message, @Nullable Location location) {
        StringBuilder sb = new StringBuilder(message).append('\n');
        if (location != null) {
            sb.append(location.toStringRepresentation()).append('\n');
            if (location instanceof WeaveLocation) {
                WeaveLocation weaveLocation = (WeaveLocation)location;
                sb.append("Location: ").append(weaveLocation.resourceWithLocation()).append('\n');
            }
        }
        return sb.toString();
    }
}

