/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.connection.oauth;

import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OAuth2PasswordAuthenticationType
extends OAuth2AuthenticationType {
    private final String tokenUrl;

    public OAuth2PasswordAuthenticationType(@Nullable String refreshUrl, List<String> scopes, String tokenUrl) {
        super(OAuth2AuthenticationType.GrantType.password, refreshUrl, scopes);
        Objects.requireNonNull(tokenUrl, "'tokenUrl' cannot be null");
        this.tokenUrl = tokenUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    public String toString() {
        return "OAuth2AuthenticationType{  subType='" + String.valueOf(this.getSubType()) + "', tokenUrl='" + this.tokenUrl + "', refreshUrl='" + this.getRefreshUrl() + "', scopes=" + String.valueOf(this.getScopes()) + "}";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2PasswordAuthenticationType that = (OAuth2PasswordAuthenticationType)o;
        return Objects.equals(this.tokenUrl, that.tokenUrl) && Objects.equals(this.getRefreshUrl(), that.getRefreshUrl()) && Objects.equals(this.getScopes(), that.getScopes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokenUrl, this.getRefreshUrl(), this.getScopes());
    }
}

