/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import com.mulesoft.connectivity.linkweave.api.interpreter.LWConnection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.model.TypeModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.test.TestUtils;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

class DataWeaveCallTest {
    private static final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();

    DataWeaveCallTest() {
    }

    @Test
    public void bind() {
        try (DataWeaveCall call = new DataWeaveCall(new ModelInterpreterConfig.Builder().build(), dataWeaveEngine);){
            call.bind("aNumber", (Object)123);
            Object res = call.evalToNullableJava("aNumber");
            MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Object)123));
        }
    }

    @Test
    public void bindConnection() {
        try (DataWeaveCall call = new DataWeaveCall(new ModelInterpreterConfig.Builder().build(), dataWeaveEngine);){
            ConnectionProviderModel provider = (ConnectionProviderModel)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)((ConnectionProviderModel.Builder)new ConnectionProviderModel.Builder().withModelReference("{ connect: (z: Any) -> z.username}")).inputType((TypeModel)new TypeModel.Builder().withDataType((DWType)TestUtils.EMPTY_OBJECT).build())).name("SomeConnection")).build();
            Map<String, String> info = Map.of("username", "pepe");
            LWConnection c = Connection.of((BaseConnectionProviderModel)provider, info);
            call.bind("connection", (Object)c);
            Object res = call.evalToJava("connection");
            MatcherAssert.assertThat((Object)res, (Matcher)Matchers.is((Object)"pepe"));
        }
    }

    @Test
    void nullHandling() {
        try (DataWeaveCall call = new DataWeaveCall(new ModelInterpreterConfig.Builder().build(), dataWeaveEngine);){
            NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> call.evalToJava("null"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Evaluation of 'null' returned null"));
            MatcherAssert.assertThat((Object)call.evalToNullableJava("null"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @Test
    public void duplicateBinding() {
        try (DataWeaveCall call = new DataWeaveCall(new ModelInterpreterConfig.Builder().build(), dataWeaveEngine);){
            call.bind("aNumber", (Object)123);
            Assertions.assertThrows(IllegalStateException.class, () -> call.bind("aNumber", (Object)321));
        }
    }

    @Test
    public void frozen() {
        try (DataWeaveCall call = new DataWeaveCall(new ModelInterpreterConfig.Builder().build(), dataWeaveEngine);){
            call.bind("aNumber", (Object)123);
            call.freeze();
            Assertions.assertThrows(IllegalStateException.class, () -> call.bind("anotherNumber", (Object)321));
        }
    }
}

