/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class LinkWeaveModelLoaderErrorTest
extends AbstractConnectivityModelTest {
    LinkWeaveModelLoaderErrorTest() {
    }

    @Test
    void failsAsExpectedWhenCompilationError() {
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> linkWeaveLoader.loadConnector("badmodule::Connector::connector"));
        Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("Invalid input 't', expected schema (line 41, column 1):\n\n\n41| type Product = {\n    ^\nLocation:\nbadmodule::Connector (line: 41, column:1)"));
    }

    @Test
    void failsAsExpectedWhenNoRefFound() {
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> linkWeaveLoader.loadConnector("test001::Connector::sarasa"));
        Assertions.assertTrue((boolean)exception.getCause().getMessage().contains("Unable to resolve reference of: `test001::Connector::sarasa`.\n\n1| test001::Connector::sarasa\n   ^^^^^^^^^^^^^^^^^^^^^^^^^^\nLocation:\nanonymous (line: 1, column:1)"));
    }
}

