/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.metadata;

import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataValueUtils;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairMetadataValue;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class MetadataValueUtilsTest {
    private final DataWeaveScriptingEngine dataWeaveEngine = new DataWeaveScriptingEngine();

    @Test
    void testAsProperties() {
        List value = (List)this.parseAndGetFieldValue("%dw 2.7\nvar v: {a: String <~ {valueProvider: {name: \"vp\"}}} = {a: \"\"}\n---v", MetadataKey.VALUE_PROVIDER, MetadataValueUtils::asProperties);
        KeyValuePairMetadataValue kv = (KeyValuePairMetadataValue)value.get(0);
        MatcherAssert.assertThat((Object)kv.getKey(), (Matcher)Matchers.is((Object)"name"));
        MatcherAssert.assertThat((Object)((LiteralMetadataValue)kv.getValue()).getValue(), (Matcher)Matchers.is((Object)"vp"));
        List<KeyValuePairMetadataValue> properties = value.stream().map(o -> (KeyValuePairMetadataValue)o).toList();
        MatcherAssert.assertThat((Object)((LiteralMetadataValue)MetadataValueUtils.getProperty(properties, (String)"name").orElseThrow()).getValue(), (Matcher)Matchers.is((Object)"vp"));
        MatcherAssert.assertThat((Object)((String)MetadataValueUtils.getStringProperty(properties, (String)"name").orElseThrow()), (Matcher)Matchers.is((Object)"vp"));
        MatcherAssert.assertThat((Object)MetadataValueUtils.requireStringProperty(properties, (String)"name"), (Matcher)Matchers.is((Object)"vp"));
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> MetadataValueUtils.requireStringProperty((List)properties, (String)"non-existent-property"));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"The 'non-existent-property' property is required."));
        ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> this.parseAndGetFieldValue("%dw 2.7\nvar v: {a: String <~ {valueProvider: \"bad\"}} = {a: \"\"}\n---v", MetadataKey.VALUE_PROVIDER, MetadataValueUtils::asProperties));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"Some metadata was supposed to be an object, but it's a string instead."));
        ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> this.parseAndGetFieldValue("%dw 2.7\nvar v: {a: String <~ {valueProvider: \"bad\"}} = {a: \"\"}\n---v", MetadataKey.VALUE_PROVIDER, v -> MetadataValueUtils.asProperties((DWMetadataValue)v, (String)"The value provider in this test")));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"The value provider in this test was supposed to be an object, but it's a string instead."));
    }

    @Test
    public void testAsSet() {
        Set value = (Set)this.parseAndGetFieldValue("%dw 2.7\nvar v: {a: String <~ {semanticTerms: [\"one\",\"two\"]}} = {a: \"\"}\n---v", MetadataKey.SEMANTIC_TERMS, MetadataValueUtils::asSet);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{"one", "two"}));
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> this.parseAndGetFieldValue("%dw 2.7\nvar bad=1\nvar v: {a: String <~ {semanticTerms: bad}} = {a: \"\"}\n---v", MetadataKey.SEMANTIC_TERMS, MetadataValueUtils::asSet));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"Some metadata was supposed to be an array, but it's a reference to a variable instead."));
    }

    @Test
    public void testAsString() {
        String value = (String)this.parseAndGetFieldValue("%dw 2.7\nvar v: {a: String <~ {label: \"x\"}} = {a: \"\"}\n---v", MetadataKey.LABEL, MetadataValueUtils::asString);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)"x"));
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> this.parseAndGetFieldValue("%dw 2.7\nvar v: {a: String <~ {label: [\"bad\"]}} = {a: \"\"}\n---v", MetadataKey.LABEL, MetadataValueUtils::asString));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"Some metadata was supposed to be a string, but it's an array instead."));
        ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> this.parseAndGetFieldValue("%dw 2.7\nvar v: {a: String <~ {label: 2}} = {a: \"\"}\n---v", MetadataKey.LABEL, MetadataValueUtils::asString));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"Some metadata was supposed to be a string, but it's a number instead."));
    }

    private Object parseAndGetFieldValue(String script, MetadataKey key, Function<DWMetadataValue, Object> value) {
        ObjectType weaveType = (ObjectType)this.dataWeaveEngine.inferTypeOf(script).get();
        DWType property = Arrays.stream(weaveType.getProperties()).filter(p -> "a".equals(p.getKeyName())).findFirst().get().getValue();
        return value.apply(MetadataValueUtilsTest.getMetadata(property, key).get().getValue());
    }

    private static Optional<DWMetadata> getMetadata(DWType weaveType, MetadataKey metadataKey) {
        return Stream.of(weaveType.getTypeMetadata()).filter(metadata -> metadataKey.getKey().equals(metadata.getName())).findFirst();
    }
}

