/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model;

import com.mulesoft.connectivity.linkweave.api.model.AbstractConnectivityModelTest;
import com.mulesoft.connectivity.linkweave.api.model.matchers.ObjectFieldMatcher;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.connector.TestConnectorModel;
import java.util.List;
import java.util.NavigableMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.StringType;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class VersioningTest
extends AbstractConnectivityModelTest {
    private final TestConnectorModel connectorModel = (TestConnectorModel)linkWeaveLoader.loadModule("versioning::Connector");

    @Test
    void testOperation() {
        OperationModel add = this.connectorModel.getOperation("add");
        NavigableMap versions = add.getVersions();
        MatcherAssert.assertThat((Object)versions, (Matcher)Matchers.aMapWithSize((int)2));
        OperationModel op = (OperationModel)versions.get(1);
        MatcherAssert.assertThat((Object)op.getName(), (Matcher)Matchers.is((Object)"add"));
        MatcherAssert.assertThat((Object)op.getDisplayName(), (Matcher)Matchers.is((Object)"Add"));
        MatcherAssert.assertThat((Object)op, (Matcher)Matchers.sameInstance((Object)add));
        ObjectType inputType = (ObjectType)op.getInputType().getDataType();
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("left", StringType.class), ObjectFieldMatcher.fieldLike("right", StringType.class)}));
        op = (OperationModel)versions.get(2);
        MatcherAssert.assertThat((Object)op.getName(), (Matcher)Matchers.is((Object)"add"));
        MatcherAssert.assertThat((Object)op.getDisplayName(), (Matcher)Matchers.is((Object)"Add"));
        inputType = (ObjectType)op.getInputType().getDataType();
        MatcherAssert.assertThat(List.of(inputType.getProperties()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{ObjectFieldMatcher.fieldLike("left", NumberType.class), ObjectFieldMatcher.fieldLike("right", NumberType.class)}));
    }

    @Test
    void testTrigger() {
        TriggerModel getUsersTrigger = this.connectorModel.getTrigger("getUsersTrigger");
        NavigableMap versions = getUsersTrigger.getVersions();
        MatcherAssert.assertThat((Object)versions, (Matcher)Matchers.aMapWithSize((int)2));
        TriggerModel t = (TriggerModel)versions.get(1);
        MatcherAssert.assertThat((Object)t.getName(), (Matcher)Matchers.is((Object)"getUsersTrigger"));
        MatcherAssert.assertThat((Object)t.getDisplayName(), (Matcher)Matchers.is((Object)"Get Users Trigger"));
        MatcherAssert.assertThat((Object)t, (Matcher)Matchers.sameInstance((Object)getUsersTrigger));
        t = (TriggerModel)versions.get(2);
        MatcherAssert.assertThat((Object)t.getName(), (Matcher)Matchers.is((Object)"getUsersTrigger"));
        MatcherAssert.assertThat((Object)t.getDisplayName(), (Matcher)Matchers.is((Object)"Get Users Trigger"));
    }
}

