/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.trigger;

import com.mulesoft.connectivity.linkweave.api.interpreter.EagerPage;
import com.mulesoft.connectivity.linkweave.api.model.trigger.EagerTriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextPoll;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public class TriggerEagerPage
extends EagerPage<EagerTriggerItem>
implements TriggerPage<EagerTriggerItem> {
    private static final long serialVersionUID = 1L;
    private final NextPoll nextPoll;

    public TriggerEagerPage(List<EagerTriggerItem> items, @Nullable Serializable nextPage, NextPoll nextPoll) {
        super(items, nextPage);
        this.nextPoll = nextPoll;
    }

    @Override
    public NextPoll getNextPoll() {
        return this.nextPoll;
    }

    @Override
    public NextData getNextData() {
        return new NextData(this.getNextPoll(), this.getNextPage().orElse(null));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("{items=").append(this.getItems());
        this.getNextPage().ifPresent(nextPage -> sb.append(", nextPage=").append(nextPage));
        sb.append(", nextPoll= { greatestWatermark=").append(this.nextPoll.getGreatestWatermark()).append(", latestWatermark=").append(this.nextPoll.getLatestWatermark()).append("}");
        return sb.append('}').toString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TriggerPage)) {
            return false;
        }
        TriggerPage result = (TriggerPage)o;
        return Objects.equals(this.getItems(), result.getItems()) && Objects.equals(this.getNextPage(), result.getNextPage()) && Objects.equals(this.nextPoll, result.getNextPoll());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getItems(), this.nextPoll, this.getNextPage());
    }

    public static TriggerPageFactory triggerPageFactory() {
        return new TriggerPageFactory();
    }

    public static class TriggerPageFactory
    extends EagerPage.AbstractPageFactory<TriggerEagerPage, EagerTriggerItem> {
        @Override
        public TriggerEagerPage fromNotPaginatedData(Object data, Function<Object, ? extends EagerTriggerItem> buildItem) {
            throw new UnsupportedOperationException("Triggers always act as paginated operations");
        }

        @Override
        public TriggerEagerPage fromPaginatedData(Object data, Function<Object, ? extends EagerTriggerItem> buildItem) {
            Map pageMap = (Map)data;
            Map nextPoll = (Map)pageMap.get("nextPoll");
            Serializable greatestWatermarkEncoded = (Serializable)nextPoll.get("greatestWatermark");
            Serializable latestWatermarkEncoded = (Serializable)nextPoll.get("latestWatermark");
            Serializable nextPageEncoded = (Serializable)pageMap.get("nextPage");
            return new TriggerEagerPage(this.getItems(buildItem, pageMap), nextPageEncoded, new NextPoll(greatestWatermarkEncoded, latestWatermarkEncoded));
        }
    }
}

