/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.loader;

import com.mulesoft.connectivity.linkweave.api.loader.ContextVariablesResolver;
import com.mulesoft.connectivity.linkweave.api.loader.InvalidConnectorException;
import com.mulesoft.connectivity.linkweave.api.model.provider.ObjectFieldSelector;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.weave.v2.api.tooling.impl.ts.catalog.DefaultDWTypeCatalog;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.catalog.DWTypeCatalog;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

class ContextVariablesResolverTest {
    ContextVariablesResolverTest() {
    }

    @Test
    public void testMissingVariable() {
        String script = "%dw 2.8\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"valueProvider\")\nannotation ValueProvider(value: ProviderDescription)\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"with\")\nannotation With(value: ContextBinding)\n\ntype ProviderDescription = {\n  name: String,\n  args?: ContextBinding\n}\n\ntype ContextBinding = Dictionary<String>\n\ntype A = @With(value = { existing: \"/\" }) {\n    \"property\": @ValueProvider(value = {\"name\": \"vp\", \"arguments\": {\"x\":\"#missing\"} }) String\n}\nvar a: A = {\n        property: \"hola\"\n}\n---\na";
        DWType weaveType = (DWType)new DataWeaveScriptingEngine().inferTypeOf(script).get();
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> ContextVariablesResolver.resolveContextVariablesOnInput((DWType)weaveType));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"There's no context variable 'missing' defined at this point: /property. Available variables: [existing]"));
    }

    @Test
    public void doesNotCrashOnRecursiveTypes() {
        DWTypeCatalog catalog = DefaultDWTypeCatalog.loader().fromCatalog("%dw 2.0\ntype A = {\n    aa : A\n}");
        DWType dataWeaveType = (DWType)catalog.getType("A").orElseThrow();
        Assertions.assertDoesNotThrow(() -> ContextVariablesResolver.resolveContextVariablesOnInput((DWType)dataWeaveType));
    }

    @Test
    public void resolveContextVariablesInIntersection() {
        DWTypeCatalog catalog = DefaultDWTypeCatalog.loader().fromCatalog("%dw 2.8\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"metadataProvider\")\nannotation MetadataProvider(value: ProviderDescription)\n\ntype ProviderDescription = {\n  name: String,\n  args?: ContextBinding\n}\n\ntype ContextBinding = Dictionary<String>\n\ntype NestedDynamicFieldParameters = {\n    record: { id: Number} &\n            { dynamicField: @MetadataProvider(value = { name: \"nestedDynamicFieldProvider\" }) Object}\n}");
        DWType dataWeaveType = (DWType)catalog.getType("NestedDynamicFieldParameters").orElseThrow();
        Map references = ContextVariablesResolver.resolveContextVariablesOnInput((DWType)dataWeaveType);
        Assertions.assertNotNull(references.get(ObjectFieldSelector.create((String)"/record/dynamicField")));
    }

    @Test
    public void badContextVar() {
        String script = "%dw 2.8\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"valueProvider\")\nannotation ValueProvider(value: ProviderDescription)\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"with\")\nannotation With(value: ContextBinding)\n\ntype ProviderDescription = {\n  name: String,\n  args?: ContextBinding\n}\n\ntype ContextBinding = Dictionary<String>\n\ntype A = @With(value = { z: \"/missing\" }) {\n    \"property\": @ValueProvider(value = {\"name\": \"vp\", \"arguments\": {\"x\": \"#z\"} }) String\n}\nvar a: A = {\n        property: \"hola\"\n}\n---\na";
        DWType weaveType = (DWType)new DataWeaveScriptingEngine().inferTypeOf(script).get();
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> ContextVariablesResolver.resolveContextVariablesOnInput((DWType)weaveType));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"Context variable 'z': Selector '/missing' doesn't exist in the type: A"));
    }

    @Test
    public void badArgument() {
        String script = "%dw 2.8\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"valueProvider\")\nannotation ValueProvider(value: ProviderDescription)\n\n@AnnotationTarget(targets = [\"KeyType\", \"Type\", \"TypeExpression\"])\n@Metadata(key = \"with\")\nannotation With(value: ContextBinding)\n\ntype ProviderDescription = {\n  name: String,\n  args?: ContextBinding\n}\n\ntype ContextBinding = Dictionary<String>\n\ntype A = {\n    \"property\": @ValueProvider(value = {\"name\": \"vp\", \"arguments\": {\"x\": \"/missing\"} }) String\n}\nvar a: A = {\n        property: \"hola\"\n}\n---\na";
        DWType weaveType = (DWType)new DataWeaveScriptingEngine().inferTypeOf(script).get();
        InvalidConnectorException ex = (InvalidConnectorException)Assertions.assertThrows(InvalidConnectorException.class, () -> ContextVariablesResolver.resolveContextVariablesOnInput((DWType)weaveType));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.startsWith((String)"Value passed into parameter selector 'x': Selector '/missing' doesn't exist in the type: A"));
    }
}

